/*********************************************************************************************************************
File Name	: techwell.h
Author		: ST Chen
Date			: 2006.09.02
Note			: 1. btcx_riscmem -> define in "btcx-risc.h"
			:	struct btcx_riscmem {	unsigned int   size;
			:						u32            *cpu;
			:						u32            *jmp;
			:						dma_addr_t     dma;  };	
			: 2. int  btcx_riscmem_alloc(	struct pci_dev *pci,
			:						struct btcx_riscmem *risc,
			:						unsigned int siz   );
			: 3. void btcx_riscmem_free(	struct pci_dev *pci,
		       	:						struct btcx_riscmem *risc ) ;
		       	: 4. dma_addr_t = u64 --> define in "types.h"
			:		  
**********************************************************************************************************************/

//#define	DebugLevel				1


#define	DBGFlag			0 
#define 	DBGDMAFlag		0		
#define 	DBGVBIFlag			0
#define	DBGVideoFlag		0
#define	DBGSwitchFlag		0
#define	DBGMMAPFlag 		0
#define	DBGFPSFlag 		0	

#define	DBG_DeviceNumber	10 

#define 	DBG( fmt, arg... )  if ( DBGFlag > 0 ) \
		printk( fmt, ## arg ) 

#define 	DBG_DMA( fmt, arg... )  if ( DBGDMAFlag  > 0 ) \
		printk( fmt, ## arg ) 

#define 	DBG_VBI( fmt, arg... )  if ( DBGVBIFlag > 0 ) \
		printk( fmt, ## arg ) 

#define 	DBG_VIDEO( fmt, arg... )  if ( DBGVideoFlag > 0 ) \
		printk( fmt, ## arg ) 

#define 	DBG_SWITCH( fmt, arg... )  if ( (DBGSwitchFlag > 0)&&(btv->c.nr<DBG_DeviceNumber) ) \
		printk( fmt, ## arg ) 

#define		DBG_MMAP( fmt, arg... ) 	if( (DBGMMAPFlag > 0)&&(btv->c.nr<DBG_DeviceNumber) ) printk( fmt, ## arg )

#define		DBG_FPS( fmt, arg... ) 	if( (DBGFPSFlag > 0) /*&&(btv->c.nr<DBG_DeviceNumber)*/ ) printk( fmt, ## arg )



/*
#define	DBG( Level, s... ) {
			if ( (Level) ) {
				printk( KERN_INFO (s) ) ;
			}

		}
*/


// ST_0115, for kernel 2.6.27 support 
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,6,24)	
#define	STATE_ACTIVE		VIDEOBUF_ACTIVE
#define	STATE_DONE			VIDEOBUF_DONE
#define	STATE_PREPARED		VIDEOBUF_PREPARED
#define	STATE_QUEUED		VIDEOBUF_QUEUED
#define	STATE_ERROR		VIDEOBUF_ERROR
#define	STATE_NEEDS_INIT	VIDEOBUF_NEEDS_INIT
#endif


void
tw_DisableDMA
(
	struct bttv *btv
) ;

void
tw_EnableDMA
(
	struct bttv *btv
) ;

// ST_0508_ADD, for scale value setting 
void
tw_set_scale( struct bttv *btv ) ;
//



#define	TW6801_MAX_FBUF					0x208000


#define	TW6801_VERSION_CODE				0x000101
#define 	PCI_VENDOR_ID_TW6801				0x1797
#define 	PCI_DEVICE_ID_TW6801				0x6801
#define 	PCI_DEVICE_ID_TW6805				0x6804

/* ST_0128, for tw6816 */
#define 	PCI_DEVICE_ID_TW6810				0x6810
#define 	PCI_DEVICE_ID_TW6811				0x6811
#define 	PCI_DEVICE_ID_TW6812				0x6812
#define 	PCI_DEVICE_ID_TW6813				0x6813


#define 	TW6801_PCI_SUBSYSTEM_VENDOR_ID	0x2c
#define 	TW6801_PCI_SUBSYSTEM_ID			0x2e

#define 	TW6801_PCI_CLASS_REVISION			0x08	/* High 24 bits are class, low 8 revision */
#define	TW6801_PCI_REVISION_ID				0x08	/* Revision ID */

#define 	TW6801_PCI_LATENCY_TIMER			0x0d	/* 8 bits */

#define 	TW6801_AINT_MASK					0x104

// 
#define	TW6801_BOARD_PCI_CARD				0x91

// ST_0616
 #define 	TW6801_TIMEOUT						msecs_to_jiffies(1500) 	// 500 ms	// ST_0413
// #define 	TW6801_TIMEOUT							msecs_to_jiffies(800) 

#define 	TW6801_RISC_TIMEOUT					msecs_to_jiffies(10) 	// 80 ms



// TW6801 Register

// VBI Control
#define	TW6801_VBIC					0x10
#define	TW6801_VBIC_DWC			16		// VBI Packet Size 		
#define	TW6801_VBIC_FRAME			(1<<2)	// Enable VBI Frame mode
#define	TW6801_VBIC_EVEN			(1<<1)
#define	TW6801_VBIC_ODD			(1)
#define	TW6801_VBIC_CONVF			(1<<15)


// I2C Control 
#define	TW6801_SBUSC					0x14
#define	TW6801_SB_HARDWARE			(1)
#define	TW6801_SB_WREN				(1<<1)
#define	TW6801_SSCLK					(1<<6)
#define	TW6801_SSDAT					(1<<7)
#define	TW6801_SB_READ				(1<<24)
#define	TW6801_SB_WRITE				(0<<24)


// I2C Data
#define	TW6801_SBUSSD					0x18
#define	TW6801_SBUSRD					0x30
#define 	TW6801_SBUSTRIG				0x34

// Interrupt status 
#define	TW6801_INTSTAT					0x1C
#define 	TW6801_SBDONE					1	
#define	TW6801_VDMAPI					(1<<1)
#define	TW6801_FFOF					(1 << 3)
#define	TW6801_DMAERR					(1<<5)
#define	TW6801_VLOCK					(1<<19)
#define	TW6801_FIELD					(1<<20)
#define	TW6801_SLOCK					(1<<21)
#define	TW6801_HLOCK					(1<<22)
// ST_ADD_1129 for Remote Control Support 
#define	TW6801_GPINT					(1<<2)
#define	TW6801_REMERR					(1<<28)
#define	TW6801_UPDINT					(1<<27)
#define	TW6801_HTINT					(1<<26)


// Gpio control 
#define	TW6801_GPIOC					0x24
#define	TW6801_GPIOC_GPMODE			(7)
#define	TW6801_GPIOC_GPMODE_NORMAL	(0)
#define	TW6801_GPIOC_GPMODE_BT656_27	(1)
#define	TW6801_GPIOC_GPMODE_BT656		(4)
#define	TW6801_GPIOC_GP2SEN			(1<<3)
#define	TW6801_GPIOC_INV656				(1<<6)
#define	TW6801_GPIOC_GPCLKINOPL		(1<<7)
#define	TW6801_GPIOC_GPI656PORT		(1<<11)
#define	TW6801_GPIOC_GPINT				(3<<12)
#define	TW6801_GPIOC_GPINT_LEVEL_HIGH	(0<<12)
#define	TW6801_GPIOC_GPINT_LEVEL_LOW	(1<<12)
#define	TW6801_GPIOC_GPINT_EDGE_HIGH	(2<<12)
#define	TW6801_GPIOC_GPINT_EDGE_LOW	(3<<12)

// TEST Register
#define	TW6801_TEST_REG				0x02c



//Video Capture Control 
#define	TW6801_CAP_CTL					0x40
#define	TW6801_CAP_CTL_ODD				1
#define	TW6801_CAP_CTL_EVEN			(1<<1)

// Left/Right Clock divider 6 bits avaliable 
#define	TW6801_LRDIV					0x31C


// DMA Type
#define	TW6801_DMA_TYPE_SYNCO			(0x0CU<<28)
#define	TW6801_DMA_TYPE_SYNCE				(0x0DU<<28)
#define	TW6801_DMA_TYPE_JUMP				(0x0BU<<28)
#define	TW6801_DMA_TYPE_LINESTART			(0x09U<<28)
#define	TW6801_DMA_TYPE_INLINE				(0x0AU<<28)
#define	TW6801_DMA_TYPE_DUMMY			(0x0EU<<28)

// IRQ bit for video dma control 
#define	TW6801_DMA_IRQ						(1<<27)
#define	TW6801_DMA_SOL						(1<<24)



// Video DMA Control
#define	TW6801_VDMAC						0x000
#define	TW6801_VDMAC_VDMATRIG				(0x0FF<<8)
#define	TW6801_VDMAC_GAMMA				(1<<7)
#define	TW6801_VDMAC_COLORF				(7<<4)

#define	TW6801_VDMAC_COLORF_YUY2			(4<<4)
#define	TW6801_VDMAC_COLORF_RGB15		(3<<4)
#define	TW6801_VDMAC_COLORF_RGB16		(2<<4)
#define	TW6801_VDMAC_COLORF_RGB24		(1<<4)
#define	TW6801_VDMAC_COLORF_RGB32		(0<<4)

#define	TW6801_VDMAC_BSWAP				(7<<2)
#define	TW6801_VDMAC_VFIFO_EN				(1<<1)
#define	TW6801_VDMAC_VDMAP_EN				(1)

//Video DMA Programmer Strating Address
#define	TW6801_VDMAP_SA					0x004

//Video DMA Programmer is Currently executing
#define	TW6801_VDMAP_EXE					0x008

//Video DMA Programmer in memory address space fetched by the DMA Programmer
#define	TW6801_VDMAP_PP					0x00C



// Interrupt Mask
#define 	TW6801_INT_MASK         				0x020

// ST_1115 for Audio Control 
#define	TW6801_GPOE						0x028

// ST_0126
#define TW68XX_SET_DMATRIG					0x060	// Set DMA Trigger



#define	TW6801_GPDATA					0x100
#define	TW6801_TV_AUDIO_GPIO			(0x0007<<13)


#define	TW6801_DSTATUS						0x204
#define	TW6801_DSTATUS_DET50				1
#define	TW6801_DSTATUS_MONO				(1<<1)
#define	TW6801_DSTATUS_NOVIDEO			(1<<2)
#define	TW6801_DSTATUS_VLOCK				(1<<3)
#define	TW6801_DSTATUS_FIELD				(1<<4)
#define	TW6801_DSTATUS_SLOCK				(1<<5)
#define	TW6801_DSTATUS_HLOCK				(1<<6)
#define	TW6801_DSTATUS_VDLOSS				(1<<7)

#define	TW6801_IFORM						0x208
#define	TW6801_IFORM_CSEL					(3)
#define	TW6801_IFORM_CSEL0					(0)
#define	TW6801_IFORM_CSEL1					(1)
#define	TW6801_IFORM_CSEL2					(2)
#define	TW6801_IFORM_CSEL3					(3)
#define	TW6801_IFORM_YSEL					(3<<2)
#define	TW6801_IFORM_YSEL0					(0<<2)	// Mux0
#define	TW6801_IFORM_YSEL1					(1<<2)	// Mux1
#define	TW6801_IFORM_YSEL2					(2<<2)	// Mux2
#define	TW6801_IFORM_YSEL3					(3<<2)	// Mux3
#define	TW6801_IFORM_IFSEL					(3<<4)	
#define	TW6801_IFORM_IFSEL0				(1<<4)	// Composite Video Decoding
#define	TW6801_IFORM_IFSEL1				(2<<4)	// S-Video Decoding
#define	TW6801_IFORM_FC27					(1<<6)	// Frequecy ...

#define	TW6801_AUDIO_SOURCE_TVTUNER		0x00
#define	TW6801_AUDIO_SOURCE_EXT_AUDIO		0x02


//  Output Format Control
#define	TW6801_OPFORM						0x20C

// Gamma and HSYNC Delay Control
#define	TW6801_HSLEN						0x210

//Analog Control
#define	TW6801_ACNTL_1						0x218

// Cropping Register Hihg 
#define	TW6801_CROP_HI						0x21C
#define	TW6801_CROP_HI2					0x3DC

// Vertical Delay Register Low
#define	TW6801_VDELAY_LO					0x220
#define	TW6801_VDELAY_LO2					0x3E0

// Vertical Active Register Low
#define	TW6801_VACTIVE_LO					0x224
#define	TW6801_VACTIVE_LO2				0x3E4



// Horizontal Delay Register Low
#define	TW6801_HDELAY_LO					0x228
#define	TW6801_HDELAY_LO2					0x3E8


// Horizontal Active Register Low
#define	TW6801_HACTIVE_LO					0x22C
#define	TW6801_HACTIVE_LO2				0x3EC


//Control Register
#define	TW6801_CNTRL1						0x230

// Horizonal Scaling Register  
#define	TW6801_VSCALE_LO					0x234
#define	TW6801_HSCALE_LO					0x23C
#define	TW6801_SCALE_HI					0x238
//#define	TW6801_HSCALE_HI					(0x07)
//#define	TW6801_VSCALE_HI					(0x07<<4)


#define	TW6801_V2SCALE_LO					0x3F4
#define	TW6801_H2SCALE_LO					0x3FC
#define	TW6801_2SCALE_HI					0x3F8
//#define	TW6801_2HSCALE_HI					(0x07)
//#define	TW6801_2VSCALE_HI					(0x07<<4)




// Brightness Control Register 
#define	TW6801_BRIGHT						0x240

// Contrast Control Register 
#define	TW6801_CONTRAST					0x244

// Sharpness Control Register
#define	TW6801_SHARPNESS_1				0x248

// Chroma(U) Gain Register 
#define	TW6801_SAT_U						0x24C

// Chroma(V) Gain Register 
#define	TW6801_SAT_V						0x250

// Hue Control Register 
#define	TW6801_HUE							0x254

// Sharpness Control Register -2 
#define	TW6801_SHARPNESS_2				0x258

// Vertical Sharpness Register 
#define	TW6801_VSHARP						0x25C

// Coring Control Register 
#define	TW6801_CORING						0x260

// ST_DEL _0128 for VBI Support 
// #define	TW6801_VBICNTL						0x264

// Analog Control Register - 2
#define	TW6801_ACNTL_2						0x268


// Standard select
#define	TW6801_SDT							0x270
#define	TW6801_SDT_STD						7
#define	TW6801_SDT_STD_NTSC_M				0
#define	TW6801_SDT_STD_PAL_BDGHI			1
#define	TW6801_SDT_STD_SECAM				2
#define	TW6801_SDT_STD_NTSC_443			3
#define	TW6801_SDT_STD_PAL_M				4
#define	TW6801_SDT_STD_PAL_CN				5
#define	TW6801_SDT_STD_PAL_60				6
#define	TW6801_SDT_STD_AUTO				7
#define	TW6801_SDT_ATREG					(1<<3)
#define	TW6801_SDT_DETSTUS				(1<<7)


// Standard Recognition Register 
#define	TW6801_SDTR						0x274

// Clamping Gain Register 
#define	TW6801_CLMPG						0x280

// Individual AGC Gain Register 
#define	TW6801_IAGC							0x284

// AGC Gain Register 
#define	TW6801_AGCGAIN						0x288

// White Peak Threhold Register 
#define	TW6801_PEAKWT						0x28C

// Clamp level Register 
#define	TW6801_CLMPL						0x290

// Sync Amplitude Register 
#define	TW6801_SYNCT						0x294

// Sync Miss Counter Register 
#define	TW6801_MISSCNT						0x298

// Clamp Position Register 
#define	TW6801_PCLAMP						0x29C

// Vertical Control Register -1
#define	TW6801_VCNTL_1						0x2A0

// Vertical Control Register -2
#define	TW6801_VCNTL_2						0x2A4

// Color Killer Level Control Register 
#define	TW6801_CKILL						0x2A8

// Comb Filter Control Register 
#define	TW6801_COMB						0x2AC

// Luma Delay and H Filter  Control Register 
#define	TW6801_LDLY						0x2B0

// Miscellaneous Control Register -1
#define	TW6801_MISC_1						0x2B4

// LOOP Control Register 
#define	TW6801_LOOP						0x2B8

// Miscellaneous Control Register -2
#define	TW6801_MISC_2						0x2BC

// MacroVersion Detection Register
#define	TW6801_MVSN						0x2C0

// Decoder Chip Status -2
#define	TW6801_STATUS_2					0x2C4

// H Monitor
#define	TW6801_HFREF						0x2C8

// Clamp Mode Register
#define	TW6801_CLMD						0x2CC

// ID Detection Control Register
#define	TW6801_IDCNTL						0x2D0

// Clamp Control Register -1
#define	TW6801_CLCNTL_1					0x2D4


//ST_0129, add for switching mode support
#define	CHANNEL_DISABLE	0
#define	CHANNEL_ENABLE		1
//
#define	DISCONNECTED			0
#define	CONNECTED				1
#define	MAX_RETRY_COUNTER		0	// ST_0309 0

// ST_0309, This value can NOT too large otherwise the driver will get timeout and re-init the channel  
#define	MAX_POLLING_COUNTER	20	// ST_0309 6, 20 
//
#define 	SWITCHING_DELAY		7 	// ST_0309	7
#define 	LOSESIGNAL_DELAY		18	// ST_0309	48
#define 	NO_POLLING_DELAY		1	// ST_0309 48, 5


/* ST_0902, for clear the buffer state to make sure the buffer could be clear after stream off */
static void
tw_clear_buffer_state( 	struct	bttv *btv ) ;


