/*************************************************

tw686x.h
used by tw686x

**************************************************/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/extensions/Xvlib.h>
#include <gtk/gtk.h>
#include <linux/version.h>
#include <linux/videodev2.h>

#ifndef TW686X_H
#define TW686X_H

#define MAX_BUF_NUM                  4
#define MAX_NAME_LEN                 128
#define MAX_CHANNEL_NUM              16

#define CFG_FILE                     "tw686x.ini"
#define CFG_SECTION_TW686X           "tw686x"
#define CFG_KEY_DEVICE_NUM           "device_num"
#define CFG_KEY_DEVICE_BEGIN         "device_begin"

#define CFG_SECTION_CHANNEL          "channel%d"
#define CFG_KEY_STANDARD             "standard"
#define CFG_KEY_PIXELFORMAT          "pixel_format"
#define CFG_KEY_WIDTH                "width"
#define CFG_KEY_HEIGHT               "height"
#define CFG_KEY_BUFFERS              "buffers"

#define CIF_RESOLUTION               0
#define HALF_D1_RESOLUTION           1
#define D1_RESOLUTION                2
#define STANDARD_PAL                 0x00FF//V4L2_STD_PAL
#define STANDARD_NTSC                0xB000//V4L2_STD_NTSC
#define IS_PAL(std)                  (std==STANDARD_PAL)
#define MAX_FRAMERATE(std)           (IS_PAL(std) ? 25 : 30)
#define CIF_WIDTH                    352
#define D1_WIDTH                     704
#define CIF_HEIGHT(std)              (IS_PAL(std) ? 288 : 240)
#define D1_HEIGHT(std)               (CIF_HEIGHT(std)*2)

#define DEFAULT_VIDEO_STANDARD       STANDARD_NTSC
#define DEFAULT_VIDEO_PIXELFORMAT    V4L2_PIX_FMT_YUYV
#define DEFAULT_VIDEO_RESOLUTION     CIF_RESOLUTION

#if(DEFAULT_VIDEO_RESOLUTION==CIF_RESOLUTION)
#define DEFAULT_VIDEO_WIDTH          CIF_WIDTH
#define DEFAULT_VIDEO_HEIGHT(std)    CIF_HEIGHT(std)
#elif(DEFAULT_VIDEO_RESOLUTION==HALF_D1_RESOLUTION)
#define DEFAULT_VIDEO_WIDTH          D1_WIDTH
#define DEFAULT_VIDEO_HEIGHT(std)    CIF_HEIGHT(std)
#else
#define DEFAULT_VIDEO_WIDTH          D1_WIDTH
#define DEFAULT_VIDEO_HEIGHT(std)    D1_HEIGHT(std)
#endif

#define SCREEN_WIDTH                 800
#define SCREEN_HEIGHT                600

#define CLEAR(x) memset (&(x), 0, sizeof (x))
#include <time.h>

#define dprintf( fmt, arg... )\
	printf( "[%s]: " fmt, "tw686x", ## arg );

#define dcprintf( chl, fmt, arg... )\
	printf( "[%s]: " fmt, (chl)->dev_video.dev_name, ## arg );

#define min(a,b)    ((a<b) ? a : b)
#define max(a,b)    ((a>b) ? a : b)

typedef struct
{
  void *start;
  size_t length;
} buffer_t;

typedef struct
{
    char  dev_name[MAX_NAME_LEN];
    int   fd;
    pthread_t cap_thread;
    buffer_t *buffers;
    unsigned int n_buffers;
} device_info_t;

typedef struct
{
    int   id;
    device_info_t dev_video;
    device_info_t dev_audio;

    unsigned char *videobuf;
    unsigned int  pix_fmt;
    int standard;
    int width;
    int height;
    int linewidth;
    int error_times;
    int interlaced;
    int framerate;
    int signal;

    int audio_opened;
    int audio_bits;
    int audio_samplerate;
    int audio_channels;

    int b_run;
    int b_quit;
    int b_show;
    int b_update;

    XvImage   *xvimage;
    pthread_mutex_t mutex;
    struct v4l2_rect rect;
} channel_t;

char * get_exe_path(char *path);

#endif //TW686X_H
