// RecordWindow.cpp : implementation file
//

#include "stdafx.h"
#include "ScfPlayer.h"
#include "RecordWindow.h"
#include "SetupDlg.h"

// CRecordWindow

IMPLEMENT_DYNAMIC(CRecordWindow, CWnd)

CRecordWindow::CRecordWindow()
{
	m_dDayStartTime = 0.0;

	m_dGlobalPlayTime = 0.0;

	for (ULONG i = 0 ; i < DEFAULT_MAX_CHANNEL_NUM ; i++)
	{
		m_dLocalPlayTime[ i ] = 0.0;

		m_bLocalPlay[ i ] = FALSE;
	}
}

CRecordWindow::~CRecordWindow()
{
}


BEGIN_MESSAGE_MAP(CRecordWindow, CWnd)
	//{{AFX_MSG_MAP(CRecordWindow)
	ON_WM_ERASEBKGND()
	ON_WM_CREATE()	
	ON_WM_DESTROY()	
	ON_WM_PAINT()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONDBLCLK()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// CRecordWindow message handlers

BOOL CRecordWindow::OnEraseBkgnd(CDC* pDC) 
{
	return TRUE;
}

void CRecordWindow::OnDestroy() 
{
	CWnd::OnDestroy();
	
	// TODO: Add your message handler code here	
}

int CRecordWindow::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CWnd::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	// TODO: Add your specialized creation code here
	
	CRect rcClient;	GetClientRect(&rcClient);

	m_dCellWidth = (rcClient.Width()) / 24.0;

	m_dCellHeight = 28;

	UINT i = 0; 

	CRect rect(0, 0, 60, 22);	
		
	rect.top    = 5;
	rect.bottom = 30;

	for (i = 0 ; i < 24 ; i++)
	{
		rect.left  = long((i * m_dCellWidth));

		rect.right = long(rect.left + m_dCellWidth);

		m_rectHourNum[ i ] = rect;		
	}

	for (i = 0 ; i < DEFAULT_MAX_CHANNEL_NUM ; i++)
	{
		m_XYPlayTriangle[ i ][ 0 ].x = 0;

		m_XYPlayTriangle[ i ][ 0 ].y = ( i * 28) + 32;			
	}

	m_XYGlobalPlayTriangle[ 0 ].x = 0;

	m_XYGlobalPlayTriangle[ 0 ].y = ( 9 * 28) + 32;

	Invalidate();

	return 0;
}

void CRecordWindow::OnPaint()
{	
	CPaintDC dc(this);	

	CDC *pDC = GetDC();
		
	HDC hDC = pDC->GetSafeHdc();

	CBrush  brush(RGB(255, 255, 255));

	CRect rt;	GetClientRect(&rt);	

	HBITMAP hBackBitmap = CreateCompatibleBitmap(hDC, rt.right - rt.left, rt.bottom - rt.top);	

	HDC hBitmapDC = ::CreateCompatibleDC(hDC);

	HBITMAP hOldBitmap = (HBITMAP)SelectObject(hBitmapDC, hBackBitmap);

	::FillRect(hBitmapDC, &rt, brush);

	// DRAW HOUR NUMBER
	//
	DrawHourNumBlock( hBitmapDC );

	// DRAW GRID LINE
	//
	DrawGridLine( hBitmapDC );

	// DRAW CHANNEL DATA
	//
	DrawChannelData( hBitmapDC );

	// DRAW GLOBAL CHANNEL DATA
	//
	DrawGlobalChannelData( hBitmapDC );

	// DRAW TRIANGLE POINTER
	//
	DrawIndividualTrianglePointer( hBitmapDC );

	// DRAW GLOBAL TRIANGLE POINTER
	//
	DrawGlobalTrianglePointer( hBitmapDC );

	// BITBLT ALL BITMAP DC TO HDC
	//
	BitBlt(hDC, rt.left, rt.top, rt.Width(), rt.Height(), hBitmapDC, 0, 0, SRCCOPY);

	SelectObject(hBitmapDC, hOldBitmap);

	DeleteDC( hBitmapDC );

	DeleteObject( hBackBitmap );

	ReleaseDC( pDC );	
}

void CRecordWindow::DrawGridLine(HDC hDC)
{
	CDC *pDC = CDC::FromHandle( hDC );	

	CRect rcClient;

    GetClientRect(&rcClient);

	HPEN hBlackPen = CreatePen(PS_SOLID, 1, RGB(92, 99, 100));

	HPEN   hOldPen; 

	hOldPen = (HPEN)::SelectObject(pDC->m_hDC, hBlackPen);
	
	UINT i = 0; 
	
	for (i = 0 ; i < 10 ; i++)
	{
		pDC->MoveTo( 0,  (i * 28) + 32 );

		pDC->LineTo( 0 + (int)(m_dCellWidth * 24 ), (i * 28) + 32);
	}
	
	for (i = 0 ; i < 25 ; i++)
	{
		pDC->MoveTo( (int)(i * m_dCellWidth) ,  32);

		pDC->LineTo( (int)(i * m_dCellWidth) , 285 );
	}	

	::SelectObject(pDC->m_hDC, hOldPen);

	DeleteObject(hBlackPen);

	ReleaseDC(pDC);
}

void CRecordWindow::DrawHourNumBlock(HDC hDC)
{
	CDC *pDC = CDC::FromHandle( hDC );

	CRect rect;

	CString strHour;

	UINT i = 0; 
	
    CPen penBlack;

    penBlack.CreatePen(PS_SOLID, 1, RGB(0, 0, 0));

    CPen* pOldPen = pDC->SelectObject(&penBlack);

	CBrush brushBlue(RGB(211, 213, 214));

	CBrush* pOldBrush = pDC->SelectObject(&brushBlue);

	pDC->SetBkColor(RGB(211, 213, 214));

	pDC->SetTextColor(RGB(0, 0, 0));	

	for (i = 0 ; i < 24 ; i++)
	{
		strHour.Format( _T("%2d"), i);

		rect = m_rectHourNum[ i ];	

		pDC->Rectangle(rect);	   

		pDC->TextOut(rect.left + (rect.Width() / 2) - 10  , rect.top + (rect.Height() / 2) - 8, strHour);
	}
	
    pDC->SelectObject(pOldBrush);

    pDC->SelectObject(pOldPen);

	ReleaseDC(pDC);
}

VOID CRecordWindow::UpdateDataRect( ULONG nCH )
{
	CSetupDlg * pParent = (CSetupDlg *)(GetParent());

	BeginWaitCursor();

	double dWindowWidth = m_dCellWidth * 24.0;

	ULONG i = 0;

	MY_SCF_FILE_INFO  dsFileInfo = {0};

	m_aryCHRectData[ nCH ].RemoveAll();

	m_aryGlobalCHRectData[ nCH ].RemoveAll();

	SYSTEMTIME	timeDayStart = {0};

	timeDayStart.wYear			 = m_timeDaySelected.wYear;
	timeDayStart.wMonth			 = m_timeDaySelected.wMonth;
	timeDayStart.wDay			 = m_timeDaySelected.wDay;
	timeDayStart.wHour			 = 0;
	timeDayStart.wMinute		 = 0;
	timeDayStart.wSecond		 = 0;
	timeDayStart.wMilliseconds   = 0;

	double dDayStartTime = 0.0;

	SystemTimeToVariantTime(&timeDayStart, &dDayStartTime);

	m_dDayStartTime = dDayStartTime * 86400.0;

	SYSTEMTIME timeRecStart, timeRecStop;

	ULONGLONG nVideoStartTime = 0;

	ULONGLONG nVideoStopTime = 0;

	for (i = 0 ; i < pParent->m_vs_file_info[ nCH ].size() ; i++)
	{
		dsFileInfo = pParent->m_vs_file_info[ nCH ][ i ];

		nVideoStartTime = (ULONGLONG)( dsFileInfo.dVideoStartTime * 10000000 );

		nVideoStopTime = (ULONGLONG)( dsFileInfo.dVideoStopTime * 10000000 );

		FileTimeToSystemTime( (FILETIME *)(&nVideoStartTime), &timeRecStart);

		FileTimeToSystemTime( (FILETIME *)(&nVideoStopTime),  &timeRecStop);

		CTime timeStart( timeRecStart.wYear, timeRecStart.wMonth, timeRecStart.wDay, timeRecStart.wHour, timeRecStart.wMinute, timeRecStart.wSecond);

		CTime timeStop( timeRecStop.wYear, timeRecStop.wMonth, timeRecStop.wDay, timeRecStop.wHour, timeRecStop.wMinute, timeRecStop.wSecond);

		CTimeSpan timeDiff; timeDiff = timeStop - timeStart;

		LONG nTimeLen = 0;

		nTimeLen = (LONG)timeDiff.GetTotalSeconds();

		double dStartTime = 0.0, dEndTime = 0.0, dTempTime = 0.0, dIntervalTime1 = 0.0, dIntervalTime2 = 0.0;

		SystemTimeToVariantTime(&timeRecStart, &dStartTime);

		dTempTime  = dDayStartTime * 86400.0;	

		dStartTime = dStartTime * 86400.0;

		dEndTime   = dStartTime + (double) nTimeLen;

		dIntervalTime1 = dStartTime - dTempTime;

		dIntervalTime2 = dEndTime - dTempTime;		

		// ADD CHANNEL RECTANGLE DATA
		//
		CRect rect(0, 0, 0, 0);

		rect.left   =  (LONG) (( dIntervalTime1 * dWindowWidth ) / 86400.0);
		rect.right  =  (LONG) (( dIntervalTime2 * dWindowWidth ) / 86400.0);

		rect.top    = ( nCH * 28) + 32;
		rect.bottom = rect.top + 28;		

		if (rect.left == rect.right)	{ rect.right = rect.left + 1; }

		m_aryCHRectData[ nCH ].Add( &rect );

		CRect rect2(0, 0, 0, 0);

		rect2.left = rect.left;			rect2.right = rect.right;
		rect2.top  = ( 9 * 28) + 32;	rect2.bottom = rect2.top + 28;

		if ( nCH == 0 && pParent->m_bChkCH01 == TRUE ) { m_aryGlobalCHRectData[ 0 ].Add( &rect2 ); }
		if ( nCH == 1 && pParent->m_bChkCH02 == TRUE ) { m_aryGlobalCHRectData[ 1 ].Add( &rect2 ); }
		if ( nCH == 2 && pParent->m_bChkCH03 == TRUE ) { m_aryGlobalCHRectData[ 2 ].Add( &rect2 ); }
		if ( nCH == 3 && pParent->m_bChkCH04 == TRUE ) { m_aryGlobalCHRectData[ 3 ].Add( &rect2 ); }
		if ( nCH == 4 && pParent->m_bChkCH05 == TRUE ) { m_aryGlobalCHRectData[ 4 ].Add( &rect2 ); }
		if ( nCH == 5 && pParent->m_bChkCH06 == TRUE ) { m_aryGlobalCHRectData[ 5 ].Add( &rect2 ); }
		if ( nCH == 6 && pParent->m_bChkCH07 == TRUE ) { m_aryGlobalCHRectData[ 6 ].Add( &rect2 ); }
		if ( nCH == 7 && pParent->m_bChkCH08 == TRUE ) { m_aryGlobalCHRectData[ 7 ].Add( &rect2 ); }
		if ( nCH == 8 && pParent->m_bChkCH09 == TRUE ) { m_aryGlobalCHRectData[ 8 ].Add( &rect2 ); }
	}
	
	EndWaitCursor();	
}

VOID CRecordWindow::UpdateGlobalDataRect( ULONG nCH )
{
	CSetupDlg * pParent = (CSetupDlg *)(GetParent());

	m_aryGlobalCHRectData[ nCH ].RemoveAll();

	BOOL bCheckedGlobal = FALSE;

	if ( nCH == 0 && pParent->m_bChkCH01 ) { bCheckedGlobal = TRUE; }
	if ( nCH == 1 && pParent->m_bChkCH02 ) { bCheckedGlobal = TRUE; }
	if ( nCH == 2 && pParent->m_bChkCH03 ) { bCheckedGlobal = TRUE; }
	if ( nCH == 3 && pParent->m_bChkCH04 ) { bCheckedGlobal = TRUE; }
	if ( nCH == 4 && pParent->m_bChkCH05 ) { bCheckedGlobal = TRUE; }
	if ( nCH == 5 && pParent->m_bChkCH06 ) { bCheckedGlobal = TRUE; }
	if ( nCH == 6 && pParent->m_bChkCH07 ) { bCheckedGlobal = TRUE; }
	if ( nCH == 7 && pParent->m_bChkCH08 ) { bCheckedGlobal = TRUE; }
	if ( nCH == 8 && pParent->m_bChkCH09 ) { bCheckedGlobal = TRUE; }

	if ( bCheckedGlobal )
	{
		if ( m_aryCHRectData[ nCH ].GetSize() > 0 )		
		{
			m_aryGlobalCHRectData[ nCH ].Copy( m_aryCHRectData[ nCH ] );

			CRect rect(0, 0, 0, 0);

			int i = 0;

			for (i = 0 ; i < m_aryGlobalCHRectData[ nCH ].GetSize() ; i++)
			{
				rect = m_aryGlobalCHRectData[ nCH ].GetAt( i );

				rect.top = ( 9 * 28) + 32;	rect.bottom = rect.top + 28;

				m_aryGlobalCHRectData[ nCH ].SetAt( i, rect );
			}			
		}
	}

	Invalidate();
}

VOID CRecordWindow::SetPlayState( ULONG nCH )
{
	CSetupDlg * pParent = (CSetupDlg *)(GetParent());	

	BOOL bCheckedGlobal = FALSE;

	if ( nCH == 0 && pParent->m_bChkCH01 ) { bCheckedGlobal = TRUE; }
	if ( nCH == 1 && pParent->m_bChkCH02 ) { bCheckedGlobal = TRUE; }
	if ( nCH == 2 && pParent->m_bChkCH03 ) { bCheckedGlobal = TRUE; }
	if ( nCH == 3 && pParent->m_bChkCH04 ) { bCheckedGlobal = TRUE; }
	if ( nCH == 4 && pParent->m_bChkCH05 ) { bCheckedGlobal = TRUE; }
	if ( nCH == 5 && pParent->m_bChkCH06 ) { bCheckedGlobal = TRUE; }
	if ( nCH == 6 && pParent->m_bChkCH07 ) { bCheckedGlobal = TRUE; }
	if ( nCH == 7 && pParent->m_bChkCH08 ) { bCheckedGlobal = TRUE; }
	if ( nCH == 8 && pParent->m_bChkCH09 ) { bCheckedGlobal = TRUE; }

	if ( bCheckedGlobal )
	{
		QCAP_SET_SCF_FILE_TIMER( nCH, TRUE );

		m_bLocalPlay[ nCH ] = FALSE;
	}
	else
	{
		QCAP_SET_SCF_FILE_TIMER( nCH, FALSE );

		m_bLocalPlay[ nCH ] = TRUE;
	}	
}

void CRecordWindow::DrawChannelData(HDC hDC)
{
	CDC *pDC = CDC::FromHandle( hDC );

	ULONG i = 0;

	CRect rectDraw;

	// DRAW CHANNEL DATA
	//
	for (i = 0 ; i < DEFAULT_MAX_CHANNEL_NUM ; i++)
	{
		for (int j = 0 ; j < m_aryCHRectData[ i ].GetSize() ; j++)
		{
			rectDraw = m_aryCHRectData[ i ].GetAt( j );
						
			pDC->FillSolidRect(rectDraw, RGB(0, 0, 255));	
		}		
	}

	ReleaseDC(pDC);
}

void CRecordWindow::DrawGlobalChannelData(HDC hDC)
{
	CDC *pDC = CDC::FromHandle( hDC );

	int i = 0;

	CRect rectDraw;

	// DRAW GLOBAL CHANNEL DATA
	//	
	for (i = 0 ; i < DEFAULT_MAX_CHANNEL_NUM ; i++)
	{
		for (int j = 0 ; j < m_aryGlobalCHRectData[ i ].GetSize() ; j++)
		{
			rectDraw = m_aryGlobalCHRectData[ i ].GetAt( j );
						
			pDC->FillSolidRect(rectDraw, RGB(155, 48 ,255));	
		}		
	}		

	ReleaseDC(pDC);
}

void CRecordWindow::OnMouseMove(UINT nFlags, CPoint point) 
{
	ULONG i = 0;

	int j = 0;

	BOOL bInChannelRect = FALSE;

	CRect rectCH;

	// IN LOCAL CHANNEL
	//
	for (i = 0 ; i < DEFAULT_MAX_CHANNEL_NUM ; i++)
	{
		for (j = 0 ; j < m_aryCHRectData[ i ].GetSize() ; j++)
		{
			rectCH = m_aryCHRectData[ i ].GetAt( j );

			if(PtInRect(&rectCH , point))
			{
				bInChannelRect = TRUE;
			}
		}
	}

	// IN GLOBAL CHANNEL
	//
	for (i = 0 ; i < DEFAULT_MAX_CHANNEL_NUM ; i++)
	{
		for (j = 0 ; j < m_aryGlobalCHRectData[ i ].GetSize() ; j++)
		{
			rectCH = m_aryGlobalCHRectData[ i ].GetAt( j );

			if(PtInRect(&rectCH , point))
			{
				bInChannelRect = TRUE;
			}
		}
	}

	if ( bInChannelRect )
	{
		SetCursor(LoadCursor( NULL, MAKEINTRESOURCE( IDC_HELP )));
	}
	else
	{
		SetCursor(LoadCursor( NULL, MAKEINTRESOURCE( IDC_ARROW )));
	}
}

void CRecordWindow::DrawIndividualTrianglePointer(HDC hDC)
{
	// DRAW TRIANGLE POINTER
	//
	UINT j = 0;

	CDC *pDC = CDC::FromHandle( hDC );

	pDC->SetBkMode( OPAQUE );

	HBRUSH hOldBrush;

	HBRUSH hBrush = CreateSolidBrush( RGB(255, 255 , 0));

	hOldBrush = (HBRUSH)::SelectObject( pDC->m_hDC, hBrush );

	UINT i = 0;		

	for (i = 0 ; i < DEFAULT_MAX_CHANNEL_NUM ; i++)
	{
		m_XYPlayTriangle[ i ][ 1 ].x = m_XYPlayTriangle[ i ][ 0 ].x - 5;
		m_XYPlayTriangle[ i ][ 1 ].y = m_XYPlayTriangle[ i ][ 0 ].y + 15;
		m_XYPlayTriangle[ i ][ 2 ].x = m_XYPlayTriangle[ i ][ 0 ].x;
		m_XYPlayTriangle[ i ][ 2 ].y = m_XYPlayTriangle[ i ][ 0 ].y + 15;
		m_XYPlayTriangle[ i ][ 3 ].x = m_XYPlayTriangle[ i ][ 0 ].x + 5;
		m_XYPlayTriangle[ i ][ 3 ].y = m_XYPlayTriangle[ i ][ 0 ].y + 15;

		m_rectPlayTriangle[ i ] = GetTriangleRect(m_XYPlayTriangle[ i ], 4);

		pDC->Polygon( m_XYPlayTriangle[ i ], 4);
	}	

	::SelectObject(pDC->m_hDC, hOldBrush);

	DeleteObject(hBrush);	

	ReleaseDC(pDC);
}

void CRecordWindow::DrawGlobalTrianglePointer(HDC hDC)
{
	// DRAW GLOBAL TRIANGLE POINTER
	//
	UINT j = 0;

	CDC *pDC = CDC::FromHandle( hDC );

	pDC->SetBkMode( OPAQUE );

	HBRUSH hOldBrush;

	HBRUSH hBrush = CreateSolidBrush( RGB(255, 0 , 0));

	hOldBrush = (HBRUSH)::SelectObject( pDC->m_hDC, hBrush );

	m_XYGlobalPlayTriangle[ 1 ].x = m_XYGlobalPlayTriangle[ 0 ].x - 5;
	m_XYGlobalPlayTriangle[ 1 ].y = m_XYGlobalPlayTriangle[ 0 ].y + 15;
	m_XYGlobalPlayTriangle[ 2 ].x = m_XYGlobalPlayTriangle[ 0 ].x;
	m_XYGlobalPlayTriangle[ 2 ].y = m_XYGlobalPlayTriangle[ 0 ].y + 15;
	m_XYGlobalPlayTriangle[ 3 ].x = m_XYGlobalPlayTriangle[ 0 ].x + 5;
	m_XYGlobalPlayTriangle[ 3 ].y = m_XYGlobalPlayTriangle[ 0 ].y + 15;

	m_rectGlobalPlayTriangle = GetTriangleRect(m_XYGlobalPlayTriangle, 4);

	pDC->Polygon( m_XYGlobalPlayTriangle, 4);

	::SelectObject(pDC->m_hDC, hOldBrush);

	DeleteObject(hBrush);
	
	HPEN hRedPen = CreatePen(PS_SOLID, 1, RGB(255, 0, 0));

	HPEN hOldPen = (HPEN)::SelectObject(pDC->m_hDC, hRedPen);

	pDC->MoveTo( (int)(m_XYGlobalPlayTriangle[ 0 ].x), 32);

	pDC->LineTo( (int)(m_XYGlobalPlayTriangle[ 0 ].x), 285 );

	::SelectObject(pDC->m_hDC, hOldPen);

	DeleteObject(hRedPen);	

	ReleaseDC(pDC);
}

CRect CRecordWindow::GetTriangleRect(CPoint *point, int nSize)
{
	CRect rect;

	rect.left = rect.right  = point[ 0 ].x;
	rect.top  = rect.bottom = point[ 0 ].y;

	for (int i = 1 ; i < nSize ; i++)
	{
		if (point[ i ].x < rect.left)
			rect.left = point[ i ].x - 1;

		if (point[ i ].x > rect.right)
			rect.right = point[ i ].x + 1;

		if (point[ i ].y < rect.top)
			rect.top = point[ i ].y - 1;

		if (point[ i ].y > rect.bottom)
			rect.bottom = point[ i ].y + 1;
	}

	return rect;
}

void CRecordWindow::UpdateIndividualTrianglePointer(UINT nCH)
{
	double dWindowWidth = m_dCellWidth * 24.0;

	double dPlayTime = 0.0, dIntervalTime = 0.0;

	dPlayTime = m_dLocalPlayTime[ nCH ] * 86400.0;

	dIntervalTime = dPlayTime - m_dDayStartTime;

	if ( dIntervalTime > 0 )
		m_XYPlayTriangle[ nCH ][ 0 ].x = (LONG) (( dIntervalTime * dWindowWidth ) / 86400.0);
	else
		m_XYPlayTriangle[ nCH ][ 0 ].x = 0;

	InvalidateRect( m_rectPlayTriangle[ nCH ] );
}

void CRecordWindow::UpdateGlobalTrianglePointer()
{
	double dWindowWidth = m_dCellWidth * 24.0;

	double dPlayTime = 0.0, dIntervalTime = 0.0;

	dPlayTime = m_dGlobalPlayTime * 86400.0;

	dIntervalTime = dPlayTime - m_dDayStartTime;

	if ( dIntervalTime > 0 )
		m_XYGlobalPlayTriangle[ 0 ].x = (LONG) (( dIntervalTime * dWindowWidth ) / 86400.0);
	else
		m_XYGlobalPlayTriangle[ 0 ].x = 0;

	InvalidateRect( m_rectGlobalPlayTriangle );
}

void CRecordWindow::OnLButtonDblClk(UINT nFlags, CPoint point) 
{
	CSetupDlg * pParent = (CSetupDlg *)(GetParent());

	pParent->UpdateData();	

	BOOL bSetLocalPos = FALSE;

	MY_SCF_FILE_INFO  dsFileInfo = {0};

	ULONG i = 0, nCH = 0;

	int j = 0;

	double dVideoStartTime = 0.0;

	double dVideoStopTime = 0.0;

	BOOL bInLocalCHRect = FALSE, bInGlobalCHRect = FALSE;

	CRect rectCH;

	if ( pParent->m_bGlobalPlay )
	{
		// IN GLOBAL CHANNEL
		//
		for (i = 0 ; i < DEFAULT_MAX_CHANNEL_NUM ; i++)
		{
			for (j = 0 ; j < m_aryGlobalCHRectData[ i ].GetSize() ; j++)
			{
				rectCH = m_aryGlobalCHRectData[ i ].GetAt( j );

				if(PtInRect(&rectCH , point))
				{
					bInGlobalCHRect = TRUE;

					dsFileInfo = pParent->m_vs_file_info[ i ][ j ];

					break;
				}
			}

			if ( bInGlobalCHRect ) { break; }
		}
		// SET GLOBAL POSITION
		//
		if ( bInGlobalCHRect )
		{
			BeginWaitCursor();		

			ULONGLONG nVideoStartTime = (ULONGLONG)( dsFileInfo.dVideoStartTime * 10000000 );

			ULONGLONG nVideoStopTime = (ULONGLONG)( dsFileInfo.dVideoStopTime * 10000000 );

			ULONGLONG nNewSamplePos = (ULONGLONG)(( ( ( point.x - rectCH.left ) * ( nVideoStopTime - nVideoStartTime ) ) / ( rectCH.right - rectCH.left ) ) + nVideoStartTime);

			double dLocalSampleTime = ( (double)nNewSamplePos / 10000000.0 );

			QCAP_SET_GLOBAL_SCF_FILE_POSITION( dLocalSampleTime );		

			EndWaitCursor();		
		}
	}

	// IN LOCAL CHANNEL
	//
	for (i = 0 ; i < DEFAULT_MAX_CHANNEL_NUM ; i++)
	{
		for (j = 0 ; j < m_aryCHRectData[ i ].GetSize() ; j++)
		{
			rectCH = m_aryCHRectData[ i ].GetAt( j );

			if(PtInRect(&rectCH , point))
			{
				bInLocalCHRect = TRUE;

				dsFileInfo = pParent->m_vs_file_info[ i ][ j ];

				dVideoStartTime = dsFileInfo.dVideoStartTime;

				dVideoStopTime = dsFileInfo.dVideoStopTime;

				break;
			}
		}

		nCH = i;

		if ( bInLocalCHRect ) { break; }
	}

	// SET LOCAL POSITION
	//
	if ( m_bLocalPlay[ nCH ] )
	{
		if ( nCH == 0 ) { pParent->OnBnClickedBtnPause1(); }
		if ( nCH == 1 ) { pParent->OnBnClickedBtnPause2(); }
		if ( nCH == 2 ) { pParent->OnBnClickedBtnPause3(); }
		if ( nCH == 3 ) { pParent->OnBnClickedBtnPause4(); }
		if ( nCH == 4 ) { pParent->OnBnClickedBtnPause5(); }
		if ( nCH == 5 ) { pParent->OnBnClickedBtnPause6(); }
		if ( nCH == 6 ) { pParent->OnBnClickedBtnPause7(); }
		if ( nCH == 7 ) { pParent->OnBnClickedBtnPause8(); }
		if ( nCH == 8 ) { pParent->OnBnClickedBtnPause9(); }

		BeginWaitCursor();

		ULONGLONG nVideoStartTime = (ULONGLONG)( dsFileInfo.dVideoStartTime * 10000000 );

		ULONGLONG nVideoStopTime = (ULONGLONG)( dsFileInfo.dVideoStopTime * 10000000 );

		ULONGLONG nNewSamplePos = (ULONGLONG)(( ( ( point.x - rectCH.left ) * ( nVideoStopTime - nVideoStartTime ) ) / ( rectCH.right - rectCH.left ) ) + nVideoStartTime);

		if( pParent->m_pScfFile[ nCH ] != NULL ) 
		{
			double dLocalSampleTime = ( (double)nNewSamplePos / 10000000.0 );

			QCAP_SET_FILE_POSITION( pParent->m_pScfFile[ nCH ], dLocalSampleTime );

			QCAP_PLAY_FILE( pParent->m_pScfFile[ nCH ] );
		}

		EndWaitCursor();
	}	
}
