﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Runtime.InteropServices;

using QCAP.NET;

namespace SC510
{
    public partial class Form1 : Form
    {
        [DllImport("kernel32.dll", CharSet = CharSet.Auto)]
        public static extern void OutputDebugString(string message);

        [StructLayout(LayoutKind.Sequential)]
        public struct RECT
        {
            public int Left;
            public int Top;
            public int Right;
            public int Bottom;
        }

        [DllImport("user32.dll")]
        [return: MarshalAs(UnmanagedType.Bool)]
        public static extern bool GetWindowRect(HandleRef hWnd, out RECT lpRect);

        [DllImport("user32.dll")]
        [return: MarshalAs(UnmanagedType.Bool)]
        public static extern bool GetClientRect(HandleRef hWnd, out RECT lpRect);

        public Form1()
        {
            InitializeComponent();
        }

        public uint i = 0;

        string m_strChipName = "SA7160 PCI";

        // DEVICE PROPERTY
        //
        public uint[] m_hVideoDevice = new uint[2];

        public uint[] m_nVideoWidth = new uint[2];

        public uint[] m_nVideoHeight = new uint[2];

        public bool[] m_bVideoIsInterleaved = new bool[2];

        public double[] m_dVideoFrameRate = new double[2];

        public bool[] m_bNoSignal = new bool[2];

        public uint[] m_nAudioChannels = new uint[2];

        public uint[] m_nAudioBitsPerSample = new uint[2];

        public uint[] m_nAudioSampleFrequency = new uint[2];

        public string m_strDefaultPath;

        public string m_strRecordPath;

        public string m_strRecordFileName;

        public string[] m_strFormatChangedOutput = new string[2];

        public volatile uint m_nShareRecordState;

        // CRITICAL SECTION OBJECT
        // 
        public Object m_hShareRecordAccessCriticalSection = new Object();

        // CHANNEL WINDOW
        //
        public MyChannelControl[] m_pChannelControl = new MyChannelControl[2];

        public MyChannelControl m_oCloneWindows;

        public MySetupControl m_cSetupControl = new MySetupControl();

        // CALLBACK FUNCTION
        //        
        EXPORTS.PF_FORMAT_CHANGED_CALLBACK m_pFormatChangedCB;

        EXPORTS.PF_NO_SIGNAL_DETECTED_CALLBACK m_pNoSignalDetectedCB;

        EXPORTS.PF_SIGNAL_REMOVED_CALLBACK m_pSignalRemovedCB;

        EXPORTS.PF_VIDEO_PREVIEW_CALLBACK m_pPreviewVideoCB;

        EXPORTS.PF_AUDIO_PREVIEW_CALLBACK m_pPreviewAudioCB;

        //  FORMAT CHANGED CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_format_changed(uint pDevice, uint nVideoInput, uint nAudioInput, uint nVideoWidth, uint nVideoHeight, uint bVideoIsInterleaved, double dVideoFrameRate, uint nAudioChannels, uint nAudioBitsPerSample, uint nAudioSampleFrequency, uint pUserData)
        {
            uint nCH = pUserData;

            // OUTPUT FORMAT CHANGED MESSAGE
            //
            string strOutput = "CH" + (nCH + 1).ToString() + " -> FORMAT CHANGED : pDevice : " + pDevice.ToString() + " , " + "nVideoInput : " + nVideoInput.ToString() + " , " +

                                        "nAudioInput : " + nAudioInput.ToString() + " , " + "nVideoWidth : " + nVideoWidth.ToString() + " , " +

                                        "nVideoHeight : " + nVideoHeight.ToString() + " , " + "bVideoIsInterleaved : " + bVideoIsInterleaved.ToString() + " , " +

                                        "dVideoFrameRate : " + dVideoFrameRate.ToString() + " , " + "nAudioChannels : " + nAudioChannels.ToString() + " , " +

                                        "nAudioBitsPerSample : " + nAudioBitsPerSample.ToString() + " , " + "nAudioSampleFrequency : " + nAudioSampleFrequency.ToString() + " , " +

                                        "pUserData : " + pUserData.ToString() + " \n";

            OutputDebugString(strOutput);

            m_nVideoWidth[nCH] = nVideoWidth;

            m_nVideoHeight[nCH] = nVideoHeight;

            m_dVideoFrameRate[nCH] = dVideoFrameRate;

            uint nVH = 0;

            string strFrameType = " P ";

            string strVideoInput = "", strAudioInput = "";

            if (nVideoInput == 0) { strVideoInput = "COMPOSITE"; } if (nVideoInput == 1) { strVideoInput = "SVIDEO"; } if (nVideoInput == 2) { strVideoInput = "HDMI"; }

            if (nVideoInput == 3) { strVideoInput = "DVI_D"; } if (nVideoInput == 4) { strVideoInput = "COMPONENTS (YCBCR)"; } if (nVideoInput == 5) { strVideoInput = "DVI_A (RGB / VGA)"; }

            if (nVideoInput == 6) { strVideoInput = "SDI"; } if (nVideoInput == 7) { strVideoInput = "AUTO"; }

            if (nAudioInput == 0) { strAudioInput = "EMBEDDED_AUDIO"; } if (nAudioInput == 1) { strAudioInput = "LINE_IN"; }

            if (bVideoIsInterleaved == 1) { nVH = nVideoHeight / 2; } else { nVH = nVideoHeight; }

            if (bVideoIsInterleaved == 1) { strFrameType = " I "; } else { strFrameType = " P "; }

            m_strFormatChangedOutput[nCH] = @" INFO : " + nVideoWidth.ToString() + " x " + nVH.ToString() + strFrameType + " @" + dVideoFrameRate.ToString() +

                " FPS , " + nAudioChannels.ToString() + " CH x " + nAudioBitsPerSample.ToString() + " BITS x " + nAudioSampleFrequency.ToString() + " HZ , " +

                " VIDEO INPUT : " + strVideoInput + " , " + " AUDIO INPUT : " + strAudioInput + " \n";

            // NO SIGNAL
            //       
            if (nVideoWidth == 0 && nVideoHeight == 0 && dVideoFrameRate == 0.0 && nAudioChannels == 0 && nAudioBitsPerSample == 0 && nAudioSampleFrequency == 0)
            {
                m_bNoSignal[nCH] = true;
            }
            else
            {
                m_bNoSignal[nCH] = false;
            }

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        // PREVIEW VIDEO CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_preview_video_buffer(uint pDevice, double dSampleTime, uint pFrameBuffer, uint nFrameBufferLen, uint pUserData)
        {
            uint nCH = pUserData;

            // ENTER CRITICAL SECTION
            //
            lock (m_hShareRecordAccessCriticalSection)
            {
                if (m_nShareRecordState > 0x00000000)
                {
                    if (nCH == 0)
                    {
                        EXPORTS.QCAP_SET_VIDEO_3D_SHARE_RECORD_L_UNCOMPRESSION_BUFFER(0, (uint)EXPORTS.ColorSpaceTypeEnum.QCAP_COLORSPACE_TYEP_YUY2, m_nVideoWidth[nCH], m_nVideoHeight[nCH], pFrameBuffer, nFrameBufferLen);
                    }

                    if (nCH == 1)
                    {
                        EXPORTS.QCAP_SET_VIDEO_3D_SHARE_RECORD_R_UNCOMPRESSION_BUFFER(0, (uint)EXPORTS.ColorSpaceTypeEnum.QCAP_COLORSPACE_TYEP_YUY2, m_nVideoWidth[nCH], m_nVideoHeight[nCH], pFrameBuffer, nFrameBufferLen);
                    }

                    if (nCH == 0)
                    {
                        EXPORTS.QCAP_SET_VIDEO_3D_SHARE_RECORD_UNCOMPRESSION_BUFFER(0);
                    }
                }
            }
            //
            // LEAVE CRITICAL SECTION 

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        // PREVIEW AUDIO CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_preview_audio_buffer(uint pDevice, double dSampleTime, uint pFrameBuffer, uint nFrameBufferLen, uint pUserData)
        {
            uint nCH = pUserData;

            // ENTER CRITICAL SECTION
            //
            lock (m_hShareRecordAccessCriticalSection)
            {
                if (m_nShareRecordState > 0x00000000)
                {
                    if (nCH == 0)
                    {
                        EXPORTS.QCAP_SET_AUDIO_SHARE_RECORD_UNCOMPRESSION_BUFFER(0, pFrameBuffer, nFrameBufferLen);
                    }
                }
            }
            //
            // LEAVE CRITICAL SECTION             

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        // NO SIGNAL DETEACTED CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_no_signal_detected(uint pDevice, uint nVideoInput, uint nAudioInput, uint pUserData)
        {
            uint nCH = pUserData;

            OutputDebugString("No Signal Detected  \n");

            m_nVideoWidth[i] = 0;

            m_nVideoHeight[i] = 0;

            m_bVideoIsInterleaved[i] = false;

            m_dVideoFrameRate[i] = 0.0;

            m_nAudioChannels[i] = 0;

            m_nAudioBitsPerSample[i] = 0;

            m_nAudioSampleFrequency[i] = 0;

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        // SIGNAL REMOVED CALLBACK FUNCTION
        //
        EXPORTS.ReturnOfCallbackEnum on_process_signal_removed(uint pDevice, uint nVideoInput, uint nAudioInput, uint pUserData)
        {
            uint nCH = pUserData;

            OutputDebugString("Signal Removed \n");

            m_nVideoWidth[i] = 0;

            m_nVideoHeight[i] = 0;

            m_bVideoIsInterleaved[i] = false;

            m_dVideoFrameRate[i] = 0.0;

            m_nAudioChannels[i] = 0;

            m_nAudioBitsPerSample[i] = 0;

            m_nAudioSampleFrequency[i] = 0;

            return EXPORTS.ReturnOfCallbackEnum.QCAP_RT_OK;
        }

        public Screen ScreenFromPoint(Point p)
        {
            System.Drawing.Point pt = new System.Drawing.Point((int)p.X, (int)p.Y);

            return Screen.AllScreens.Where(scr => scr.Bounds.Contains(pt)).FirstOrDefault();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            for (i = 0; i < 2; i++)
            {
                m_hVideoDevice[i] = 0;

                m_nVideoWidth[i] = 0;

                m_nVideoHeight[i] = 0;

                m_bVideoIsInterleaved[i] = false;

                m_dVideoFrameRate[i] = 0.0;

                m_nAudioChannels[i] = 0;

                m_nAudioBitsPerSample[i] = 0;

                m_nAudioSampleFrequency[i] = 0;

                m_bNoSignal[i] = true;
            }

            m_nShareRecordState = 0x00000000;

            m_strRecordPath = Directory.GetCurrentDirectory();            

            m_oCloneWindows = new MyChannelControl(); // BACKGROUND WINDOW

            m_oCloneWindows.Parent = this;

            m_oCloneWindows.Left = 960 - 320; m_oCloneWindows.Top = 540 - 240;

            m_oCloneWindows.Size = new System.Drawing.Size(320, 240);

            m_oCloneWindows.Visible = false;

            // INITIALIZE MAIN WINDOW
            //
            RECT rectWindowMain;

            GetWindowRect(new HandleRef(null, this.Handle), out rectWindowMain);

            RECT rectClientMain;

            GetClientRect(new HandleRef(null, this.Handle), out rectClientMain);

            int nWindowWidthMain = rectWindowMain.Right - rectWindowMain.Left;

            int nWindowHeightMain = rectWindowMain.Bottom - rectWindowMain.Top;

            int nClientWidthMain = rectClientMain.Right - rectClientMain.Left;

            int nClientHeightMain = rectClientMain.Bottom - rectClientMain.Top;

            int cxMain = nWindowWidthMain - nClientWidthMain;		        // GET DEFAULT BOUNDARY WIDTH OF DIALOG

            int cyMain = nWindowHeightMain - nClientHeightMain;		// GET DEFAULT BOUNDARY HEIGHT OF DIALOG           

            this.Size = new System.Drawing.Size(cxMain + 960, cyMain + 540);
          
            for (i = 0; i < 2; i++)
            {
                m_pChannelControl[i] = new MyChannelControl();

                m_pChannelControl[i].Parent = this;

                m_pChannelControl[i].Left = 0; m_pChannelControl[i].Top = 0;

                m_pChannelControl[i].Size = new System.Drawing.Size(cxMain + 960, cyMain + 540);

                m_pChannelControl[i].Visible = true;
            }            

            m_pChannelControl[1].Visible = false;

            m_oCloneWindows.Visible = false;

            // INITIALIZE SETUP DIALOG
            //
            m_cSetupControl = new MySetupControl();

            m_cSetupControl.m_pMainForm = this;

            m_cSetupControl.FormClosed += new System.Windows.Forms.FormClosedEventHandler(this.SetupControlClosed);           

            Point point = new Point(this.Left, this.Top);

            Screen myScreen = ScreenFromPoint(point);

            Rectangle oMonitorRect = myScreen.WorkingArea;                        

            RECT rectWindow;

            GetWindowRect(new HandleRef(this, m_cSetupControl.Handle), out rectWindow);

            RECT rectClient;

            GetClientRect(new HandleRef(this, m_cSetupControl.Handle), out rectClient);

            int nMonitorWidth = oMonitorRect.Width;

            int nMonitorHeight = oMonitorRect.Height;

            int nWindowWidth = rectWindow.Right - rectWindow.Left;

            int nWindowHeight = rectWindow.Bottom - rectWindow.Top;

            int nClientWidth = rectClient.Right - rectClient.Left;

            int nClientHeight = rectClient.Bottom - rectClient.Top;

            int cx = nWindowWidth - nClientWidth;

            int cy = nWindowHeight - nClientHeight;

            this.Left = m_cSetupControl.Left = (nMonitorWidth - (960 + cx)) / 2;

            m_cSetupControl.Top = (nMonitorHeight - (105 + 40 + cy));

            m_cSetupControl.Size = new System.Drawing.Size(cx + 960, cy + 400);

            m_cSetupControl.Visible = true;

            m_cSetupControl.Show();
           
            HwInitialize();
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            HwUninitialize();
        }

        public bool HwInitialize()
        {
            EXPORTS.QCAP_CREATE(ref m_strChipName, 0, (uint)m_cSetupControl.m_statLeftWindow.Handle.ToInt32(), ref m_hVideoDevice[0], 1, 0);

            EXPORTS.QCAP_CREATE(ref m_strChipName, 1, (uint)m_cSetupControl.m_statRightWindow.Handle.ToInt32(), ref m_hVideoDevice[1], 1, 0);            

            // REGISTER FORMAT CHANGED CALLBACK FUNCTION
            // 
            m_pFormatChangedCB = new EXPORTS.PF_FORMAT_CHANGED_CALLBACK(on_process_format_changed);

            EXPORTS.QCAP_REGISTER_FORMAT_CHANGED_CALLBACK(m_hVideoDevice[0], m_pFormatChangedCB, 0);

            EXPORTS.QCAP_REGISTER_FORMAT_CHANGED_CALLBACK(m_hVideoDevice[1], m_pFormatChangedCB, 1);

            // REGISTER PREVIEW VIDEO CALLBACK FUNCTION
            // 
            m_pPreviewVideoCB = new EXPORTS.PF_VIDEO_PREVIEW_CALLBACK(on_process_preview_video_buffer);

            EXPORTS.QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK(m_hVideoDevice[0], m_pPreviewVideoCB, 0);

            EXPORTS.QCAP_REGISTER_VIDEO_PREVIEW_CALLBACK(m_hVideoDevice[1], m_pPreviewVideoCB, 1);

            // REGISTER PREVIEW AUDIO CALLBACK FUNCTION
            //
            m_pPreviewAudioCB = new EXPORTS.PF_AUDIO_PREVIEW_CALLBACK(on_process_preview_audio_buffer);

            EXPORTS.QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK(m_hVideoDevice[0], m_pPreviewAudioCB, 0);

            EXPORTS.QCAP_REGISTER_AUDIO_PREVIEW_CALLBACK(m_hVideoDevice[1], m_pPreviewAudioCB, 1);

            // REGISTER NO SIGNAL DETECTED CALLBACK FUNCTION
            //
            m_pNoSignalDetectedCB = new EXPORTS.PF_NO_SIGNAL_DETECTED_CALLBACK(on_process_no_signal_detected);

            EXPORTS.QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK(m_hVideoDevice[0], m_pNoSignalDetectedCB, 0);

            EXPORTS.QCAP_REGISTER_NO_SIGNAL_DETECTED_CALLBACK(m_hVideoDevice[1], m_pNoSignalDetectedCB, 1);

            // REGISTER SIGNAL REMOVED CALLBACK FUNCTION
            //
            m_pSignalRemovedCB = new EXPORTS.PF_SIGNAL_REMOVED_CALLBACK(on_process_signal_removed);

            EXPORTS.QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK(m_hVideoDevice[0], m_pSignalRemovedCB, 0);

            EXPORTS.QCAP_REGISTER_SIGNAL_REMOVED_CALLBACK(m_hVideoDevice[1], m_pSignalRemovedCB, 1);

            EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hVideoDevice[0], 0);

            EXPORTS.QCAP_SET_VIDEO_DEINTERLACE(m_hVideoDevice[1], 0);

            EXPORTS.QCAP_SET_AUDIO_VOLUME(m_hVideoDevice[0], 100);

            EXPORTS.QCAP_SET_AUDIO_VOLUME(m_hVideoDevice[1], 100);

            EXPORTS.QCAP_RUN(m_hVideoDevice[0]);

            EXPORTS.QCAP_RUN(m_hVideoDevice[1]);

            timerCheckSignal.Enabled = true;

            // INITIALIZE SHARE RECORDING RESOURCE
            // 
            double fps = m_dVideoFrameRate[0];

            if (m_bVideoIsInterleaved[0]) { fps /= 2; }

            EXPORTS.QCAP_SET_VIDEO_SHARE_RECORD_PROPERTY(0, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_INTEL_MEDIA_SDK, (uint)EXPORTS.VideoEncoderFormatEnum.QCAP_ENCODER_FORMAT_H264_3D, (uint)EXPORTS.ColorSpaceTypeEnum.QCAP_COLORSPACE_TYEP_YUY2, 1920, 1080, 60, (uint)EXPORTS.RecordModeEnum.QCAP_RECORD_MODE_CBR, 8000, 4000000, 30, 0, 0, (uint)m_pChannelControl[0].Handle.ToInt32(), 1, 0);

            EXPORTS.QCAP_SET_AUDIO_SHARE_RECORD_PROPERTY(0, (uint)EXPORTS.EncoderTypeEnum.QCAP_ENCODER_TYPE_SOFTWARE, (uint)EXPORTS.AudioEncoderFormatEnum.QCAP_ENCODER_FORMAT_AAC, 2, 16, 48000, 100);

            //EXPORTS.QCAP_START_SHARE_RECORD( 0, "3D.TS", (uint)(EXPORTS.RecordFlagEnum.QCAP_RECORD_FLAG_ENCODE | EXPORTS.RecordFlagEnum.QCAP_RECORD_FLAG_FILE) );

            string pszFilePathName = "3D.TS";

            EXPORTS.QCAP_START_SHARE_RECORD(0, ref pszFilePathName, (uint)EXPORTS.RecordFlagEnum.QCAP_RECORD_FLAG_DISPLAY);

            lock (m_hShareRecordAccessCriticalSection)
            {
                m_nShareRecordState = 0x00000001;
            }

            return true;
        }

        public bool HwUninitialize()
        {
            timerCheckSignal.Enabled = false;

            // UNINITIALIZE DEVICE RESOURCE
            // 
            lock (m_hShareRecordAccessCriticalSection)
            {
                m_nShareRecordState = 0x00000000;
            }

            EXPORTS.QCAP_STOP_SHARE_RECORD(0);

            for (i = 0; i < 2; i++)
            {
                if (m_hVideoDevice[i] != 0)
                {
                    EXPORTS.QCAP_STOP(m_hVideoDevice[i]);

                    EXPORTS.QCAP_DESTROY(m_hVideoDevice[i]);

                    m_hVideoDevice[i] = 0;
                }
            }

            return true;
        }

        private void SetupControlClosed(object sender, FormClosedEventArgs e)
        {
            this.Close();
        }

        private void timerCheckSignal_Tick(object sender, EventArgs e)
        {
            for (i = 0; i < 2; i++)
            {
                if (m_bNoSignal[0] && m_bNoSignal[1])
                {
                    if (i == 0) { m_cSetupControl.m_editDeviceFormatInformation_1.Text = "INFO :..."; }

                    if (i == 1) { m_cSetupControl.m_editDeviceFormatInformation_2.Text = "INFO :..."; }

                    m_pChannelControl[0].Visible = false;

                    m_pChannelControl[1].Visible = true;
                }
                else
                {
                    if (i == 0) { m_cSetupControl.m_editDeviceFormatInformation_1.Text = m_strFormatChangedOutput[0]; }

                    if (i == 1) { m_cSetupControl.m_editDeviceFormatInformation_2.Text = m_strFormatChangedOutput[1]; }

                    m_pChannelControl[0].Visible = true;

                    m_pChannelControl[1].Visible = false;
                }
            } 
        }

        public void OnLButtonDblClk_ChannelControl()
        {
            Point point = new Point(this.Left, this.Top);

            Screen myScreen = ScreenFromPoint(point);

            Rectangle oMonitorRect = myScreen.Bounds;

            RECT oWindowRect;

            GetWindowRect(new HandleRef(null, this.Handle), out oWindowRect);         

            int nMonitorWidth = oMonitorRect.Width;

            int nMonitorHeight = oMonitorRect.Height;

            int nWindowWidth = 0;

            int nWindowHeight = 0;

            nWindowWidth = oWindowRect.Right - oWindowRect.Left;

            nWindowHeight = oWindowRect.Bottom - oWindowRect.Top;

            if (nWindowWidth < nMonitorWidth)
            {
                m_pChannelControl[0].Left = 0;

                m_pChannelControl[0].Top = 0;

                m_pChannelControl[0].Size = new System.Drawing.Size(nMonitorWidth, nMonitorHeight);

                m_pChannelControl[1].Left = 0;

                m_pChannelControl[1].Top = 0;

                m_pChannelControl[1].Size = new System.Drawing.Size(nMonitorWidth, nMonitorHeight);

                m_oCloneWindows.Left = nMonitorWidth - 320;

                m_oCloneWindows.Top = nMonitorHeight - 240;

                this.Left = oMonitorRect.Left;

                this.Top = oMonitorRect.Top;

                this.Size = new System.Drawing.Size(nMonitorWidth, nMonitorHeight);
            }
            else
            {
                m_pChannelControl[0].Left = 0;

                m_pChannelControl[0].Top = 0;

                m_pChannelControl[0].Size = new System.Drawing.Size(960, 540);

                m_pChannelControl[1].Left = 0;

                m_pChannelControl[1].Top = 0;

                m_pChannelControl[1].Size = new System.Drawing.Size(960, 540);

                m_oCloneWindows.Left = 960 - 320;

                m_oCloneWindows.Top = 540 - 240;

                m_oCloneWindows.Size = new System.Drawing.Size(320, 240);

                this.Left = (nMonitorWidth - 960) / 2;

                this.Top = (nWindowHeight - 540) / 2;

                this.Size = new System.Drawing.Size(960, 540);
            }           
        }
    }
}
