// scdecode.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "scdecode.h"

#include <cstdlib>
#include <cstdio>
#include <fstream>
#include <iostream>   // std::cout
#include <string>     // std::string
#include <sstream>
#include <iomanip>
#include <vector>

using std::fstream;

#include <VFW.H>

#include "AMESDK.H"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// The one and only application object

CWinApp theApp;

using namespace std;

string GetFilePath( ULONG nState ) 
{
	// SELECT THE ACTION SCRIPT FILE
	//
	OPENFILENAME ofn;

	CHAR psz[ MAX_PATH ];

	ZeroMemory( &ofn, sizeof(ofn) );

	ofn.lStructSize = sizeof(ofn);

	ofn.hwndOwner = NULL;

	ofn.lpstrFile = psz;

	ofn.lpstrFile[ 0 ] = '\0';

	ofn.nMaxFile = sizeof(psz);

	if( 0 == nState ) { ofn.lpstrFilter = "TXT\0*.TXT\0"; }

	if( 1 == nState ) { ofn.lpstrFilter = "H264\0*.H264\0"; }

	ofn.nFilterIndex = 1;

	ofn.lpstrFileTitle = NULL;

	ofn.nMaxFileTitle = 0;

	ofn.lpstrInitialDir = NULL;

	ofn.Flags = OFN_PATHMUSTEXIST | OFN_FILEMUSTEXIST;

	GetOpenFileName( &ofn );

	string str = psz;

	return str;
}

int _tmain(int argc, TCHAR* argv[], TCHAR* envp[])
{
	cout << argv[ 0 ] << endl;

	cout << "\n/////////////////////////////////////////////////////\n" << endl;

	// 1. 
	//
	string str_txt;

	string str_h264;

	str_txt = GetFilePath( 0 );

	if( 0 == str_txt.length() ) { cout << "Read *.TXT Failed!!" << endl; return 0; }

	str_h264 = GetFilePath( 1 );

	if( 0 == str_h264.length() ) { cout << "Read *.H264 Failed!!" << endl; return 0; }

	cout << str_txt << endl;

	cout << str_h264 << endl;

	CHAR psz[ MAX_PATH ];

	::GetModuleFileName( NULL, psz, MAX_PATH );

	psz[ strlen( psz ) - 12 ] = 0x00;

	sprintf( psz, "%s%s", psz, "OUTPUT.TXT" );

    fstream f_txt( str_txt.c_str(), ios::in );							// READ FILE

	fstream f_out( psz, ios::out | ios::trunc );						// WRITE FILE

	fstream f_h264( str_h264.c_str(), ios::in | ios::binary );			// READ H.264
	
//	ULONGLONG llReadPos = 0;

	// [2014.11.12] [HUENGPEI@YUAN.COM.TW] INITIALIZE COM RESOURCE
	//
	{	HRESULT hr = CoInitialize( NULL );
	}

	// INITILIZE AMESDK PARAM
	//
	DEVICE_HANDLE m_hVideoDecoderDev = 0xFFFFFFFF;
	
	m_hVideoDecoderDev = AMESDK_CREATE( "Common Analog Intel Decoder (H.264)", 0, 6, NULL, NULL, NULL );

	if( m_hVideoDecoderDev & 0x80000000 ) { m_hVideoDecoderDev = 0xFFFFFFFF; }

	ULONG cx = 1920;

	ULONG cy = 1080;

	double fps = 29.97;

	AMESDK_SET_FORMAT( m_hVideoDecoderDev, MAKEFOURCC('H', '2', '6', '4'), cx, cy, 24, fps ); // RESOLUTION / FRAMERATE
	
	AMESDK_RUN( m_hVideoDecoderDev );
	
	UINT nDecodeSize = 0;

	UINT nFileSize = 0;
	
	//	ALLOCATE MEMORY
	//	
	CHAR * pEncBuffer = new CHAR[ 1920 * 1080 * 2 ];
	
	CHAR * pDecBuffer = new CHAR[ 1920 * 1080 * 2 ];

	ULONG nCout = 0;

	string strOut;

	// 2.READ DATA
	//
	do
	{
		// 2.1 
		//
		string str;			

		string strBufferLen;

		string strIsKeyFrame;

		getline( f_txt, str );

		ULONG nPos = 0;

		if( 0xFFFFFFFF != (nPos = str.find( "," )) )
		{
			strBufferLen = str.substr( 0, nPos );

			strIsKeyFrame = str.substr( nPos + 1, str.length() - nPos + 1 );
		}
		else
		{
			continue;
		}

		stringstream ss;

		ULONG nBufferLen = 0;

		ULONG nIsKeyFrame = 0;

		ss << strBufferLen; 
		ss >> nBufferLen;
		ss.str("");
		ss.clear();

		ss << strIsKeyFrame; 
		ss >> nIsKeyFrame;
		ss.str("");
		ss.clear();
		
		// 2.2
		//
		if( !f_h264.fail() )
		{
			// GET LENGTH OF FILE:
			//
			f_h264.seekg( 0, f_h264.end );

			nFileSize = f_h264.tellg();

			f_h264.seekg( 0, f_h264.beg );
			
			// READ DATA AS A BLOCK:
			//
			f_h264.read( pEncBuffer, nBufferLen );
			
			if ( !f_h264.fail() )
			{
				ULONG nDecBufferLen = nBufferLen;

				BOOL bRet = AMESDK_CODEC_DECODE_EX( m_hVideoDecoderDev, (BYTE * )pEncBuffer, nBufferLen, nIsKeyFrame, (BYTE * )pDecBuffer, &nDecBufferLen );

				if( bRet )
				{
					nDecodeSize += nBufferLen;					

					CHAR sz[ MAX_PATH ];

					sprintf( sz, "%d frame, decode a buffer size : %d, encode a buffer size : %d\n", nCout, nDecBufferLen, nBufferLen );

					strOut += sz;

					cout << setw(2) << nCout << " frame, " << "decode a buffer size :" << nDecBufferLen << ", encode a buffer size : " << nBufferLen <<  endl;
				}
			}
			else
			{
				CHAR sz[ MAX_PATH ];

				sprintf( sz, "error: only %d could be read\n", f_h264.gcount() );

				strOut += sz;

				cout << "error: only " << f_h264.gcount() << " could be read" << endl;
			}

			nCout++;
		}

	} while( !f_txt.eof() );

	cout << "Total Decode Size : " << nDecodeSize << ", Actual File Dize : " << nFileSize  << endl;

	f_out << strOut << endl;

	f_out << "Total Decode Size : " << nDecodeSize << ", Actual File Dize : " << nFileSize  << endl;

	if( m_hVideoDecoderDev != 0xFFFFFFFF ) { AMESDK_DESTROY( m_hVideoDecoderDev ); m_hVideoDecoderDev = 0xFFFFFFFF; }

	// [2014.11.12] [HUENGPEI@YUAN.COM.TW] UNINITIALIZE COM RESOURCE
	//
	{	CoUninitialize();
	}

	delete[] pEncBuffer;

	delete[] pDecBuffer;

    f_txt.close();

	f_out.close();

	f_h264.close();

	getchar();

	return 1;
}


