// Security_DemoDlg.h : header file
//

#if !defined(AFX_SECURITY_DEMODLG_H__92E42A9E_9293_4DF1_B69F_F64D383EDAF0__INCLUDED_)
#define AFX_SECURITY_DEMODLG_H__92E42A9E_9293_4DF1_B69F_F64D383EDAF0__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "MyViewManager.h"

#include "MyVideoWnd.h"

#include "MyLiveAV.h"

#include "MySwitchLiveAV.h"

#include "MyRecordAV.h"

#include "MySwEncodeAV.h"

#include "MyHwEncodeAV.h"

#define IDM_USE_INTEL	 999
#define IDM_RECORD_CH01  1000
#define IDM_RECORD_ALL   1001
#define IDM_STOP_RECORD  1002
#define IDM_PLAYBACK	 1003
#define IDM_SHOW_INFO	 1004
#define IDM_SAVE_AVI	 1005
#define IDM_CLOSE		 1006

typedef struct _SC_CH_INFO
{
	ULONG   nCH;

	ULONG   nWidth;

	ULONG   nHeight;

	ULONG	m_nFileWidth;

	ULONG	m_nFileHeight;

	bool    bDeinterlace;

	double  dFrameRate;

	ULONG   nRecordMode;

	ULONG   nBitRate;

	ULONG   nQuality;

	ULONG	nGop;

	ULONG	nDropFrame;

	_SC_CH_INFO()
	{
		nCH				= 0;

		nWidth			= 352;

		nHeight			= 240;

		m_nFileWidth	= 704;

		m_nFileHeight	= 480;

		bDeinterlace	= false;

		dFrameRate		= 29.97;

		nRecordMode		= 1;

		nBitRate		= 4096;

		nQuality		= 8000;

		nGop			= 30;

		nDropFrame		= 0;
	}


} SC_CH_INFO;

/////////////////////////////////////////////////////////////////////////////
// CSecurity_DemoDlg dialog

class CSecurity_DemoDlg : public CDialog
{
// Construction
public:
	CSecurity_DemoDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CSecurity_DemoDlg)
	enum { IDD = IDD_SECURITY_DEMO_DIALOG };
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CSecurity_DemoDlg)
	public:
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CSecurity_DemoDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnDestroy();
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnCloseSystem();
	afx_msg void OnUseIndel();
	afx_msg void OnSaveAVI();
	afx_msg void OnRecordCH01();
	afx_msg void OnRecordAll();
	afx_msg void OnStopRecord();
	afx_msg void OnShowInfo();
	afx_msg void OnPlayback();
	afx_msg void OnTimer(UINT nIDEvent);
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

public:	

	BOOL			 m_bUseIntelCodec;

	BOOL			 m_bSaveAVIFile;

	UINT           m_nActiveFullWndCH;

	// WINDOW RESOLUTION
	//
	BOOL			 m_bSetWindowRes;

	ULONG			 m_nWinWidth;

	ULONG			 m_nWinHeight;

	BOOL			 m_bRecordCH01;

	PVOID			 m_pCustomVideoRenderer1; // FOR INSERTING MULTIPLE CHANNEL WINDOWS
	
	PVOID			 m_pCustomVideoRenderer2; // FOR INSERTING SINGLE FULL SCREEN WINDOW

	PVOID			 m_pOverlayFullWindow;

	PVOID			 m_pOverlayWindow[ 32 ];

	MyViewManager  * m_pViewManager;

	MyVideoWnd		 m_oVideoWnd[ 36 ];	

	MyVideoWnd		 m_oFullVideoWnd;

	MyLiveAV *		 m_pLiveAV[ 32 ];		  // PREVIEW

	MySwitchLiveAV * m_pSwitchLiveAV[ 32 ];	  // FOR SWITCH CARD PREVIEW

	MyRecordAV *	 m_pRecordAV[ 32 ];		  // RECORD FILE

	MySwEncodeAV *   m_pSwEncodeAV[ 32 ];     // SOFTWARE ENCODER

	MyHwEncodeAV *   m_pHwEncodeAV[ 32 ];	  // HARDWARE ENCODER

	CStdioFile *     m_pIniFile;

	CString			 m_strChipName;

	ULONG			 m_nChannelNum;    

	ULONG			 m_nStandard;	   // 0x00000001 : NTSC, 0x00000010 : PAL

	ULONG			 m_nVideoType;     // 1 : SD, 2 : HD

	ULONG			 m_nVideoInput;	   // FOR HD , HDMI : 0x00000000, SDI : 0x00000004

	ULONG			 m_nColorSpace;

	ULONG			 m_nBitCount;

	SC_CH_INFO		 m_YChInfo[ 32 ];	// Yuan

	SC_CH_INFO		 m_IChInfo[ 32 ];	// Intel

	CMenu			 m_PopupMenu;

	BOOL			 m_bShowInfo;

	int				 m_nSwitchType;    // 0 : N, 1 : D, 2 : Q	

	CShowInfoDlg	 m_ShowInfoDlg;

	CBitmap			 bmpChkedMenu;

	CBitmap			 bmpUnChkedMenu;

public:

	BOOL HwInitialize();				// NON SWITCH

	BOOL HwInitializeDoubleSwitch();	// DOUBLE SWITCH

	BOOL HwInitializeQuadSwitch();		// QUAD SWITCH

	BOOL HwUnInitialize();

	VOID SwitchSwCodec();

	CString GetWorkingPath(CString strWorkFile);

	BOOL OpenIniFile(CString strFilePath);

	BOOL CloseIniFile();

	BOOL IsFileExists(const TCHAR* pFile);

	CStringVector SplitString(const CString& strSource, const CString& delim, bool bRemoveNone);	

	void SmallWindowToFullWindow();

	void FullWindowToSmallWindow();
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_SECURITY_DEMODLG_H__92E42A9E_9293_4DF1_B69F_F64D383EDAF0__INCLUDED_)
