// QMultiplexerDlg.h : header file
//

#if !defined(AFX_QMULTIPLEXERDLG_H__07BED6F1_8610_49A9_8CEF_E75E6B9F9B74__INCLUDED_)
#define AFX_QMULTIPLEXERDLG_H__07BED6F1_8610_49A9_8CEF_E75E6B9F9B74__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "ChannelWindow.h"

#include "ControlPnael.h"

#pragma once
// a menu class for each CQSecurityDemoDlg
typedef struct tagMenuInfo
{
	BYTE nSourceType;

	BYTE nResolutionType;
	
	BOOL nStandardType;	

	BOOL nRecordType1;

	BOOL nRecordType2;

	BOOL nRecordType3;

	BOOL nAudioType;

	BOOL nAudioInput;

} MenuInfo, *pMenuInfo;

/////////////////////////////////////////////////////////////////////////////
// CQMultiplexerDlg dialog

class CQMultiplexerDlg : public CDialog
{
// Construction
public:
	CQMultiplexerDlg(CWnd* pParent = NULL);	// standard constructor

// Dialog Data
	//{{AFX_DATA(CQMultiplexerDlg)
	enum { IDD = IDD_QMULTIPLEXER_DIALOG };
		// NOTE: the ClassWizard will add data members here
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CQMultiplexerDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CQMultiplexerDlg)
	virtual BOOL OnInitDialog();
	afx_msg void OnPaint();
	afx_msg HCURSOR OnQueryDragIcon();
	afx_msg void OnDestroy();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnMenuCsourcHdmi();
	afx_msg void OnMenuCsourcComponents();
	afx_msg void OnMenuCsourcSvideo();
	afx_msg void OnMenuCsourcComposite();
	afx_msg void OnMenuCsourcDvid();
	afx_msg void OnMenuCsourcDvia();
	afx_msg void OnMenuCsourcSdi();
	afx_msg void OnMenuCsourcAuto();
	afx_msg void OnMenuStandardNtsc();
	afx_msg void OnMenuStandardPal();
	afx_msg void OnMenuResolution1920x1080();
	afx_msg void OnMenuResolution1280x720();
	afx_msg void OnMenuResolution720x576();
	afx_msg void OnMenuResolution720x480();
	afx_msg void OnMenuStream1StartRecode();
	afx_msg void OnMenuStream1StopRecode();
	afx_msg void OnMenuStream2StartRecode();
	afx_msg void OnMenuStream2StopRecode();
	afx_msg void OnMenuStream3StartRecode();
	afx_msg void OnMenuStream3StopRecode();
	afx_msg void OnMenuAudioTurnOff();
	afx_msg void OnMenuAudioTurnOn();
	afx_msg void OnMenuSaveBitmap();
	afx_msg void OnMenuSaveJpeg();
	afx_msg void OnRadioInputEmbeddedAudio();
	afx_msg void OnRadioInputLinein();
	afx_msg void OnMenuSetVideoConfig();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

public:


	// STATIC CLASS VARIABLE
	//
	static CHAR			s_sz_dlg_title[ MAX_PATH ];

	static CRect		s_rect_slipts_display[ 4 * 4 ];

	static BYTE			s_n_splits_division;

	static ULONG		s_n_max_device_count;

	static ULONG		s_n_device_count;	

	static CQMultiplexerDlg* s_pCQMultiplexerDlgMainDlg;	

	// USER INTERFACE FUNCTION
	//
	BOOL				SetCurrentWindowLayout_CControlPanel( BYTE nGridCount, BYTE nWindowLayoutType );

	CRect				GetSplitWndPos_CQMultiplexerDlg( ULONG nWindowNumber , ULONG nGridDivisions, ULONG nRendererWidth, ULONG nRendererHeight );

	BOOL				OnRButtonDown_CChannelWindow( ULONG nChannelNum, CPoint point, CWnd *pWnd);
	
	BOOL				OnLButtonDown_CChannelWindow( ULONG nChannelNum, UINT nFlags, CPoint point );
	
	BOOL				OnMenuItemDown_ChangeSource( ULONG nType, ULONG nCannelNum );

	BOOL				OnMenuItemDown_ChangeStandard( ULONG nType, ULONG nCannelNum );

	BOOL				OnMenuItemDown_ChangeResolution( ULONG nType, ULONG nCannelNum );
	
	BOOL				OnButtonRecordStart1AVI_CControlPanel( ULONG nChannelNum );

	BOOL				OnButtonRecordStop1AVI_CControlPanel( ULONG nChannelNum );

	BOOL				OnButtonRecordStart2AVI_CControlPanel( ULONG nChannelNum );

	BOOL				OnButtonRecordStop2AVI_CControlPanel( ULONG nChannelNum );

	BOOL				OnButtonRecordStart3AVI_CControlPanel( ULONG nChannelNum );

	BOOL				OnButtonRecordStop3AVI_CControlPanel( ULONG nChannelNum );

	BOOL				OnButtonVideoQuality_CQMultiplexerDlg();
	
	// DEVICE FUNCTION
	// 
	BOOL				HwUnInitialize();

	BOOL				HwInitialize();

	// USER INTERFACE PROPERTY
	// 	
	CChannelWindow		m_oChannelWindow_LIVE[ 4 * 4 ];					// LIVE STREAM DISPLAY WINDOW	

	CChannelWindow		m_oChannelWindows_BKGND[ 4 * 4 ];				// BACKGROUND DISPLAY WINDOW

	MenuInfo			m_oMenuInfo[ 4 * 4 ];
	
	CControlPnael		m_oControlPanelDlg;	
	
	ULONG				m_nCurRBntNum;

	ULONG				m_nAudioPlayChannel;
	
	BOOL				m_nWndState;

	BYTE				m_nWndowLayoutType;

	BYTE				m_nMainWindowNum;

	BOOL				m_bNoSignal[ 4 * 4 ];

	BYTE*				pYUVCopy;

	BYTE*				pRGB;

	CBitmap				m_Bitmap;

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////// QUALITY PROPERTIES
	
	ULONG				m_nSharpness;

	ULONG				m_nSaturation;

	ULONG				m_nHue;

	ULONG				m_nConstrast;

	ULONG				m_nBrightness;

	// DEVICE PROPERTY
	// 	
	PVOID				m_hVideoDevice[ 4 * 4 ];	// VIDEO STREAM CAPTURE DEVICE
	
	PVOID				m_hCloneCapDev;

	//	OUTPUT STRING
	//
	CString				m_strFormatChangedOutput[ 4 * 4 ];

	CString				m_strRecordPath;

};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_QMULTIPLEXERDLG_H__07BED6F1_8610_49A9_8CEF_E75E6B9F9B74__INCLUDED_)
