#pragma once
#include "afxwin.h"

#define SCRIPTS_PACKS 4

#define SCRIPT_START_ADDR	0x3C00//3F80
#define SCRIPT_END_ADDR		0x3FB0
// CPanelScripts dialog
class CDcDcUsbDlg;

class CPanelScripts : public CDialog
{
	DECLARE_DYNAMIC(CPanelScripts)

public:
	CPanelScripts(CDcDcUsbDlg* mainDlg, CWnd* pParent = NULL);   // standard constructor
	virtual ~CPanelScripts();

// Dialog Data
	enum { IDD = IDD_DIALOG_SCRIPTS };
public:
	bool LoadValues(bool reset_all, bool visual);
	void AddPackage(unsigned long address, unsigned long length, HArray* parray);

	int getLoadStatus();
	unsigned char* getPackage(){return m_chPackages;};
protected:
	CDcDcUsbDlg* m_pMainDlg;
	bool m_bPackagesArrived[SCRIPTS_PACKS];
	unsigned char m_chPackages[SCRIPTS_PACKS*16];
	unsigned long m_nLastSelectedAddress;

	void Display4Steps();

	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()
public:
	afx_msg void OnBnClickedButtonScriptStart();
	afx_msg void OnBnClickedButtonScriptStop();
	CButton m_bSend;
	virtual BOOL OnInitDialog();
	CEdit m_eVoltage;
	CComboBox m_cbScriptNo;
	CComboBox m_cbVoutT1;
	CComboBox m_cbVoutT2;
	CComboBox m_cbVAuxT1;
	CComboBox m_cbVAuxT2;
	CComboBox m_cbVPswT1;
	CComboBox m_cbVPswT2;
	CEdit m_eVOutT1;
	CEdit m_eVOutT2;
	CEdit m_eVAuxT1;
	CEdit m_eVAuxT2;
	CEdit m_eVPwsT1;
	CEdit m_eVPwsT2;
	CEdit m_eGlobalWTime;
	CButton m_bScriptNext;
	CButton m_bScriptRepeat;
	afx_msg void OnCbnSelchangeComboScriptno();
	afx_msg void OnBnClickedButtonScriptSend();
	afx_msg void OnBnClickedButtonScriptSleep();
	CButton m_cbDisable;
	afx_msg void OnBnClickedCheckScriptDisable();
};
