// DcDcUsbDlg.cpp : implementation file
//

#include "stdafx.h"
#include "DcDcUsb.h"
#include "DcDcUsbDlg.h"
#include "HIDDevices.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#define PANEL_HEIGHT 420

// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CDcDcUsbDlg dialog




CDcDcUsbDlg::CDcDcUsbDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CDcDcUsbDlg::IDD, pParent)
	, m_strVIn(_T(""))
	, m_strIgn(_T(""))
	, m_strVOut(_T(""))
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_pDcDcUsb = NULL;
	m_nActivePanel = PANEL_NONE;
	m_nVoltageCfg = -1;
	m_bRefreshStatus = true;
	m_bVersion = 0;
}

void CDcDcUsbDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_EDIT_VIN, m_strVIn);
	DDX_Text(pDX, IDC_EDIT_IGN, m_strIgn);
	DDX_Text(pDX, IDC_EDIT_VOUT, m_strVOut);
	DDX_Control(pDX, IDC_EDIT_VOUTSET, m_eVout);
	DDX_Control(pDX, IDC_CHECK_AUXVIN, m_bAuxVin);
	DDX_Control(pDX, IDC_CHECK_PWSW, m_bPowerSwitch);
	DDX_Control(pDX, IDC_CHECK_OUTPUT, m_bOutput);
	DDX_Control(pDX, IDC_CHECK_PANEL_STATUS, m_bPanelStatus);
	DDX_Control(pDX, IDC_CHECK_PANEL_SETTINGS, m_bPanelSettings);
	DDX_Control(pDX, IDC_CHECK_PANEL_SCRIPTS, m_bPanelScripts);
	DDX_Control(pDX, IDC_CHECK_PANEL_MINI, m_bPanelMinimize);
	DDX_Control(pDX, IDC_BUTTON_VOUT_SET_SAVE, m_buttonSetSave);
}

BEGIN_MESSAGE_MAP(CDcDcUsbDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_WM_DESTROY()
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_CHECK_AUXVIN, &CDcDcUsbDlg::OnBnClickedCheckAuxvin)
	ON_BN_CLICKED(IDC_CHECK_PWSW, &CDcDcUsbDlg::OnBnClickedCheckPwsw)
	ON_BN_CLICKED(IDC_CHECK_OUTPUT, &CDcDcUsbDlg::OnBnClickedCheckOutput)
	ON_BN_CLICKED(IDC_BUTTON_VOUT_SET, &CDcDcUsbDlg::OnBnClickedButtonVoutSet)
	ON_BN_CLICKED(IDC_BUTTON_VOUT_UP, &CDcDcUsbDlg::OnBnClickedButtonVoutUp)
	ON_BN_CLICKED(IDC_BUTTON_VOUT_DOWN, &CDcDcUsbDlg::OnBnClickedButtonVoutDown)
	ON_BN_CLICKED(IDC_CHECK_PANEL_STATUS, &CDcDcUsbDlg::OnBnClickedCheckPanelStatus)
	ON_BN_CLICKED(IDC_CHECK_PANEL_SETTINGS, &CDcDcUsbDlg::OnBnClickedCheckPanelSettings)
	ON_BN_CLICKED(IDC_CHECK_PANEL_MINI, &CDcDcUsbDlg::OnBnClickedCheckPanelMini)
	ON_BN_CLICKED(IDC_CHECK_PANEL_SCRIPTS, &CDcDcUsbDlg::OnBnClickedCheckPanelScripts)
	ON_BN_CLICKED(IDCANCEL, &CDcDcUsbDlg::OnBnClickedCancel)
	ON_BN_CLICKED(IDOK, &CDcDcUsbDlg::OnBnClickedOk)
	ON_BN_CLICKED(IDC_BUTTON_VOUT_SET_SAVE, &CDcDcUsbDlg::OnBnClickedButtonVoutSetSave)
END_MESSAGE_MAP()


// CDcDcUsbDlg message handlers

void CDcDcUsbDlg::deviceChanged()
{
	TRACE("DEvice changed\n");

	if (m_pDcDcUsb && m_pDcDcUsb->getParent()->isOpened()) return;

	SetWindowText("DCDCUSB DEVICE DISCONNECTED!");

	if (m_pDcDcUsb)
	{
		TRACE("Device killed\n");

		KillTimer(m_nRefreshTimer);
		KillTimer(m_nMainTimer);
		m_nMainTimer = -1;
		m_nRefreshTimer = -1;
		m_nVoltageCfg = -1;
		m_bRefreshStatus = true;
		m_bVersion = 0;
		m_buttonSetSave.SetWindowText("Set and save VOut (Voltage X)");

		HIDDevice* dev = m_pDcDcUsb->getParent();
		delete m_pDcDcUsb;
		delete dev;
		m_pDcDcUsb = NULL;
	}

	char manuf[100];strcpy(manuf, MANUFACTURER);
	char prod_str[100];strcpy(prod_str, PROD_NORMAL);

	HIDDevices hdevs;
	HIDDescriptor* hdesc = hdevs.chooseHIDDevice(manuf, prod_str, NULL, DCDCUSB_VID, DCDCUSB_PID);
	if (hdesc)
	{
		TRACE("Device recreated\n");
		m_pPanelSettings->resetAll(false);

		HIDDevice* dev = hdevs.openDevice(hdesc);
		m_pDcDcUsb = new HIDDcDcUsb(dev, 5000);
		SetWindowText("DCDCUSB Device Connected!");

		m_nMainTimer    = SetTimer(1, 200, 0);
		m_nRefreshTimer = SetTimer(2, 500, 0);

		m_pDcDcUsb->GetAllParams();
		m_pDcDcUsb->sendMessage(DCDCUSB_CMD_OUT, 3, CMD_READ_VOUT, 0 ,0);

		m_pPanelStatus->m_editRegulatorSteps.SetWindowText("undefined");

		m_bPanelSettings.EnableWindow(TRUE);
		m_bPanelScripts.EnableWindow(TRUE);

		m_pPanelSettings->LoadValues(false);
	}
}

BOOL CDcDcUsbDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	m_pPanelStatus = new CPanelStatus(this, this);
	m_pPanelStatus->Create(IDD_DIALOG_STATUS,this);
	m_pPanelStatus->MoveWindow(15,150,540,PANEL_HEIGHT-20);
	m_pPanelStatus->ShowWindow(SW_HIDE);

	m_pPanelSettings = new CPanelSettings(this, this);
	m_pPanelSettings->Create(IDD_DIALOG_SETTINGS,this);
	m_pPanelSettings->MoveWindow(15,150,540,PANEL_HEIGHT-20);
	m_pPanelSettings->ShowWindow(SW_HIDE);

	m_pPanelScripts = new CPanelScripts(this, this);
	m_pPanelScripts->Create(IDD_DIALOG_SCRIPTS,this);
	m_pPanelScripts->MoveWindow(15,150,540,PANEL_HEIGHT-20);
	m_pPanelScripts->ShowWindow(SW_HIDE);

	CRect rect;GetWindowRect(&rect);rect.bottom -= PANEL_HEIGHT;MoveWindow(rect);
	m_nActivePanel = PANEL_NONE;

	char manuf[100];strcpy(manuf, MANUFACTURER);
	char prod_str[100];strcpy(prod_str, PROD_NORMAL);

	SetWindowText("DCDCUSB DEVICE DISCONNECTED!");

	m_nMainTimer = -1;
	m_nRefreshTimer = -1;

	HIDDevices hdevs;
	HIDDescriptor* hdesc = hdevs.chooseHIDDevice(manuf, prod_str, NULL, DCDCUSB_VID, DCDCUSB_PID);
	if (hdesc)
	{
		HIDDevice* dev = hdevs.openDevice(hdesc);

		m_pDcDcUsb = new HIDDcDcUsb(dev, 5000);

		m_nMainTimer    = SetTimer(1, 200, 0);
		m_nRefreshTimer = SetTimer(2, 1000, 0);

		m_pDcDcUsb->GetAllParams();
		m_pDcDcUsb->sendMessage(DCDCUSB_CMD_OUT, 3, CMD_READ_VOUT, 0, 0);

		m_pPanelStatus->m_editRegulatorSteps.SetWindowText("undefined");

		m_pPanelSettings->LoadValues(true);
	}
	else
	{
		m_bPanelSettings.EnableWindow(FALSE);
		m_bPanelScripts.EnableWindow(FALSE);
		AfxMessageBox(_T("Device not found"));
	}

	OnBnClickedCheckPanelStatus();

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CDcDcUsbDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CDcDcUsbDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CDcDcUsbDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CDcDcUsbDlg::OnDestroy()
{
	CDialog::OnDestroy();

	if (m_pDcDcUsb)
	{
		KillTimer(m_nRefreshTimer);
		KillTimer(m_nMainTimer);

		HIDDevice* dev = m_pDcDcUsb->getParent();
		delete m_pDcDcUsb;
		delete dev;
	}
	m_pDcDcUsb = NULL;

	m_pPanelStatus->DestroyWindow();
	delete m_pPanelStatus;

	m_pPanelSettings->DestroyWindow();
	delete m_pPanelSettings;

	m_pPanelScripts->DestroyWindow();
	delete m_pPanelScripts;
}

void CDcDcUsbDlg::parseMessage(HArray* parray)
{
	//TRACE("len = %d\n", parray->length());
	if (parray && parray->length()>=24)
	{
		switch (parray->getAt(0))
		{
		case INTERNAL_MESG:
			{
				switch (parray->getAt(1))
				{
				case INTERNAL_MESG_DISCONNECTED:
					{
						SetWindowText("DCDCUSB DEVICE DISCONNECTED!");
						m_bPanelSettings.EnableWindow(FALSE);
						m_bPanelScripts.EnableWindow(FALSE);
						m_pPanelSettings->resetAll(true);
						
						if ((m_nActivePanel != PANEL_NONE)&&(m_nActivePanel != PANEL_STATUS))
							OnBnClickedCheckPanelStatus();
					}break;
				}
			}break;
		case DCDCUSB_RECV_ALL_VALUES:
			{
				m_pPanelStatus->m_strTimeCfg.Format("%d",(parray->getAt(1) >> 5) & 0x7);

				int nVoltageCfg = (parray->getAt(1) >> 2) & 0x7;
				m_pPanelStatus->m_strVoltCfg.Format("%d",nVoltageCfg);

				if (nVoltageCfg != m_nVoltageCfg)
				{
					m_nVoltageCfg = nVoltageCfg;
					CString str;
					str.Format("Set and save VOut (Voltage %d)",m_nVoltageCfg);
					m_buttonSetSave.SetWindowText(str);
				}

				m_pPanelStatus->m_strMode.Format("%02d",(parray->getAt(1)) & 0x3);

				m_pPanelStatus->m_strState.Format("%02x",(char)parray->getAt(2));

				float val;
				//VIN
				val = (float)parray->getAt(3)*(float)0.1558;
				m_strVIn.Format("%.2f",val);

				//Ign
				val = (float)parray->getAt(4)*(float)0.1558;
				m_strIgn.Format("%.2f",val);

				//VOut
				val = (float)parray->getAt(5)*(float)0.1170;
				m_strVOut.Format("%.2f",val);

				int status1 = parray->getAt(6);
				if (status1 & 0x4) m_bPowerSwitch.SetCheck(1);
				else m_bPowerSwitch.SetCheck(0);

				if (status1 & 0x8) m_bOutput.SetCheck(1);
				else m_bOutput.SetCheck(0);

				if (status1 & 0x10) m_bAuxVin.SetCheck(1);
				else m_bAuxVin.SetCheck(0);

				m_pPanelStatus->m_strFlagsStatus1	= char2bin(parray->getAt(6));
				m_pPanelStatus->m_strFlagsStatus2	= char2bin(parray->getAt(7));
				m_pPanelStatus->m_strFlagsVoltage	= char2bin(parray->getAt(8));
				m_pPanelStatus->m_strFlagsTimer		= char2bin(parray->getAt(9));

				unsigned char script_pointer = parray->getAt(10);
				m_pPanelStatus->m_strFlashPointer.Format("%d",parray->getAt(10));

				m_pPanelStatus->m_strTimerWait		= CPanelSettings::ConvertOneValue(parray->getBuf(), 2, 11, 3, 1);//bytes2string(parray->getAt(11), parray->getAt(12));
				m_pPanelStatus->m_strTimerVout		= CPanelSettings::ConvertOneValue(parray->getBuf(), 2, 13, 3, 1);//bytes2string(parray->getAt(13), parray->getAt(14));
				m_pPanelStatus->m_strTimerVAux		= CPanelSettings::ConvertOneValue(parray->getBuf(), 2, 15, 3, 1);//bytes2string(parray->getAt(15), parray->getAt(16));
				m_pPanelStatus->m_strTimerPwSwitch	= bytes2string(parray->getAt(17), parray->getAt(18));
				m_pPanelStatus->m_strTimerOffDelay	= CPanelSettings::ConvertOneValue(parray->getBuf(), 2, 19, 3, 1);//bytes2string(parray->getAt(19), parray->getAt(20));
				m_pPanelStatus->m_strTimerHardOff	= CPanelSettings::ConvertOneValue(parray->getBuf(), 2, 21, 3, 1);//bytes2string(parray->getAt(21), parray->getAt(22));

				UpdateData(FALSE);
				m_pPanelStatus->UpdateData(FALSE);

				CString ver,modetext;
				m_bVersion = parray->getAt(23);
				ver.Format("DCDCUSB ver: %d.%d mode: %02d ", (parray->getAt(23) >> 5)& 0x07 , parray->getAt(23)& 0x1F, (parray->getAt(1)) & 0x3);
				switch ((parray->getAt(1)) & 0x3)
				{
				case 0:modetext="(Dumb)";break;
				case 1:modetext="(Automotive)";break;
				case 2:modetext="(Script)";break;
				case 3:modetext="(UPS)";break;
				}
				SetWindowText(ver+modetext);
			}break;
		case DCDCUSB_CMD_IN:
			{
				if (parray->getAt(1) != 0)
				{
					if (parray->getAt(2) == CMD_READ_REGULATOR_STEP)
						m_pPanelStatus->m_editRegulatorSteps.SetWindowText("undefined");
					else
					{
						CString str;
						str.Format("Error %d for message %02X",parray->getAt(1),parray->getAt(2));
						AfxMessageBox(str);
					}
				}
				else
				{
					switch (parray->getAt(2))
					{
					case CMD_WRITE_VOUT:
					case CMD_READ_VOUT:
					case CMD_INC_VOUT:
					case CMD_DEC_VOUT:
						{
							/*CString str;
							double v = HIDDcDcUsb::GetVOut(parray->getAt(3));
							str.Format("%.2f",v);
							m_eVout.SetWindowText(str);

							TRACE("data=%02x VOut=%f\n",parray->getAt(3), v);*/
						}break;
					case CMD_READ_REGULATOR_STEP:
						{
							CString str;
							str.Format("%d",parray->getAt(3));
							m_pPanelStatus->m_editRegulatorSteps.SetWindowText(str);
						}break;
					}
				}
			}break;
		case DCDCUSB_MEM_READ_IN:
			{
				//TX[24]:A1 C0 3F 00 10 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 
				//RX[24]:A2 C0 3F 00 10 26 24 32 05 26 23 E0 AA 00 03 00 32 0A 00 AA AA 00 00 01 
				unsigned long address	 = parray->getAt(3);
				address = (address << 8) | parray->getAt(2);
				address = (address << 8) | parray->getAt(1);
				
				unsigned long len = parray->getAt(4);

				if (len == 16)
				{
					if ((address >= 0x3FC0)&&(address <= 0x3FF0))
						m_pPanelSettings->AddPackage(address, len, parray);
					else if ((address >= SCRIPT_START_ADDR) && (address <= SCRIPT_END_ADDR))
						m_pPanelScripts->AddPackage(address, len, parray);
				}
			}break;
		}
	}
}

void CDcDcUsbDlg::OnTimer(UINT_PTR nIDEvent)
{//the timer is stopped when any button code is executed! this feature is used to do background memory read write
	if (m_pDcDcUsb)
	{
		if (nIDEvent == 1)
		{
			HArray* parray = m_pDcDcUsb->getReceivedMessage();
			while (parray)
			{
				parseMessage(parray);
				delete parray;
				parray = m_pDcDcUsb->getReceivedMessage();
			}
			
			UpdateData(FALSE);
		}
		else if (nIDEvent == 2)
		{
			//TRACE(CTime::GetCurrentTime().Format("%H:%M:%S\n"));
			if (m_bRefreshStatus)
				 m_pDcDcUsb->GetAllParams();
			else if (m_bVersion > 0x22)//version > 1.2
				m_pDcDcUsb->sendMessage(DCDCUSB_CMD_OUT, 3, CMD_READ_REGULATOR_STEP, 0 ,0);
			
			m_bRefreshStatus = !m_bRefreshStatus;
		}
	}

	CDialog::OnTimer(nIDEvent);
}

void CDcDcUsbDlg::OnBnClickedCheckAuxvin()
{
	if (m_pDcDcUsb) 
	{
		if (m_bAuxVin.GetCheck())
			 m_pDcDcUsb->sendMessage(DCDCUSB_CMD_OUT, 3, CMD_SET_AUX_WIN, 1, 0);
		else m_pDcDcUsb->sendMessage(DCDCUSB_CMD_OUT, 3, CMD_SET_AUX_WIN, 0, 0);
	}
}

void CDcDcUsbDlg::OnBnClickedCheckPwsw()
{
	if (m_pDcDcUsb) 
	{
		if (m_bPowerSwitch.GetCheck())
			 m_pDcDcUsb->sendMessage(DCDCUSB_CMD_OUT, 3, CMD_SET_PW_SWITCH, 1, 0);
		else m_pDcDcUsb->sendMessage(DCDCUSB_CMD_OUT, 3, CMD_SET_PW_SWITCH, 0, 0);
	}
}

void CDcDcUsbDlg::OnBnClickedCheckOutput()
{
	if (m_pDcDcUsb) 
	{
		if (m_bOutput.GetCheck())
			 m_pDcDcUsb->sendMessage(DCDCUSB_CMD_OUT, 3, CMD_SET_OUTPUT, 1, 0);
		else m_pDcDcUsb->sendMessage(DCDCUSB_CMD_OUT, 3, CMD_SET_OUTPUT, 0, 0);
	}
}

void CDcDcUsbDlg::OnBnClickedButtonVoutUp()
{
	if (m_pDcDcUsb && (m_pPanelStatus->m_strState.CompareNoCase("07")==0))  
		m_pDcDcUsb->sendMessage(DCDCUSB_CMD_OUT, 3, CMD_INC_VOUT, 0, 0);
}

void CDcDcUsbDlg::OnBnClickedButtonVoutDown()
{
	if (m_pDcDcUsb && (m_pPanelStatus->m_strState.CompareNoCase("07")==0)) 
		m_pDcDcUsb->sendMessage(DCDCUSB_CMD_OUT, 3, CMD_DEC_VOUT, 0, 0);
}

void CDcDcUsbDlg::OnBnClickedCheckPanelStatus()
{
	m_bPanelStatus.SetCheck(1);
	m_bPanelSettings.SetCheck(0);
	m_bPanelScripts.SetCheck(0);
	m_bPanelMinimize.SetCheck(0);

	if (m_nActivePanel != PANEL_STATUS)
	{
		switch (m_nActivePanel)
		{
		case PANEL_NONE:		{CRect rect;GetWindowRect(&rect);rect.bottom += PANEL_HEIGHT;MoveWindow(rect);}break;
		case PANEL_STATUS:		m_pPanelStatus->ShowWindow(SW_HIDE);break;
		case PANEL_SETTINGS:	m_pPanelSettings->ShowWindow(SW_HIDE);break;
		case PANEL_SCRIPTS:		m_pPanelScripts->ShowWindow(SW_HIDE);break;
		}
		m_pPanelStatus->ShowWindow(SW_SHOW);
		m_nActivePanel = PANEL_STATUS;
	}
}

void CDcDcUsbDlg::OnBnClickedCheckPanelSettings()
{
	m_bPanelStatus.SetCheck(0);
	m_bPanelSettings.SetCheck(1);
	m_bPanelScripts.SetCheck(0);
	m_bPanelMinimize.SetCheck(0);

	if (m_nActivePanel != PANEL_SETTINGS)
	{
		switch (m_nActivePanel)
		{
		case PANEL_NONE:		{CRect rect;GetWindowRect(&rect);rect.bottom += PANEL_HEIGHT;MoveWindow(rect);}break;
		case PANEL_STATUS:		m_pPanelStatus->ShowWindow(SW_HIDE);break;
		case PANEL_SETTINGS:	m_pPanelSettings->ShowWindow(SW_HIDE);break;
		case PANEL_SCRIPTS:		m_pPanelScripts->ShowWindow(SW_HIDE);break;
		}
		m_pPanelSettings->ShowWindow(SW_SHOW);
		m_nActivePanel = PANEL_SETTINGS;

		m_pPanelSettings->LoadValues(true);
	}
}

void CDcDcUsbDlg::OnBnClickedCheckPanelScripts()
{
	m_bPanelStatus.SetCheck(0);
	m_bPanelSettings.SetCheck(0);
	m_bPanelScripts.SetCheck(1);
	m_bPanelMinimize.SetCheck(0);

	if (m_nActivePanel != PANEL_SCRIPTS)
	{
		switch (m_nActivePanel)
		{
		case PANEL_NONE:		{CRect rect;GetWindowRect(&rect);rect.bottom += PANEL_HEIGHT;MoveWindow(rect);}break;
		case PANEL_STATUS:		m_pPanelStatus->ShowWindow(SW_HIDE);break;
		case PANEL_SETTINGS:	m_pPanelSettings->ShowWindow(SW_HIDE);break;
		case PANEL_SCRIPTS:		m_pPanelScripts->ShowWindow(SW_HIDE);break;
		}
		m_pPanelScripts->ShowWindow(SW_SHOW);
		m_nActivePanel = PANEL_SCRIPTS;

		m_pPanelScripts->LoadValues(true, true);
	}
}

void CDcDcUsbDlg::OnBnClickedCheckPanelMini()
{
	m_bPanelStatus.SetCheck(0);
	m_bPanelSettings.SetCheck(0);
	m_bPanelScripts.SetCheck(0);
	m_bPanelMinimize.SetCheck(1);

	if (m_nActivePanel != PANEL_NONE)
	{
		switch (m_nActivePanel)
		{
		case PANEL_NONE:		{CRect rect;GetWindowRect(&rect);rect.bottom += PANEL_HEIGHT;MoveWindow(rect);}break;
		case PANEL_STATUS:		m_pPanelStatus->ShowWindow(SW_HIDE);break;
		case PANEL_SETTINGS:	m_pPanelSettings->ShowWindow(SW_HIDE);break;
		case PANEL_SCRIPTS:		m_pPanelScripts->ShowWindow(SW_HIDE);break;
		}

		CRect rect;GetWindowRect(&rect);rect.bottom -= PANEL_HEIGHT;MoveWindow(rect);
		m_nActivePanel = PANEL_NONE;
	}
}
void CDcDcUsbDlg::OnBnClickedCancel()
{
	OnCancel();
}

void CDcDcUsbDlg::OnBnClickedOk()
{
	//OnOK();
}

void CDcDcUsbDlg::OnBnClickedButtonVoutSet()
{
	CString str;m_eVout.GetWindowText(str);
	if (str != "")
	{
		_TCHAR* end = NULL;
		double voltage = _tcstod(str.Left(8), &end);

		unsigned char val = HIDDcDcUsb::GetData(voltage);

		TRACE("VOut=%f data=%02x\n",voltage, val);

		m_pPanelStatus->m_editRegulatorSteps.SetWindowText("undefined");

		if (m_pDcDcUsb) m_pDcDcUsb->sendMessage(DCDCUSB_CMD_OUT, 3, CMD_WRITE_VOUT, val, 0);
		//m_pDcDcUsb->sendMessage(DCDCUSB_CMD_OUT, 3, CMD_READ_VOUT, 0, 0);
	}
}

void CDcDcUsbDlg::OnBnClickedButtonVoutSetSave()
{
	CString str;m_eVout.GetWindowText(str);
	if (str != "")
	{
		_TCHAR* end = NULL;
		double voltage = _tcstod(str.Left(8), &end);

		unsigned char val = HIDDcDcUsb::GetData(voltage);

		TRACE("VOut=%f data=%02x\n",voltage, val);

		m_pPanelStatus->m_editRegulatorSteps.SetWindowText("undefined");

		if (m_pDcDcUsb) m_pDcDcUsb->sendMessage(DCDCUSB_CMD_OUT, 3, CMD_WRITE_VOUT, val, 0);
		//m_pDcDcUsb->sendMessage(DCDCUSB_CMD_OUT, 3, CMD_READ_VOUT, 0, 0);

		if ((m_nVoltageCfg >= 0)&&(m_nVoltageCfg <= 7))
		{
			int pos = m_pPanelSettings->m_comboMessage.FindString(-1,"Voltage 0");
			if (pos != -1)
			{
				unsigned char mesg_no = (unsigned char)m_pPanelSettings->m_comboMessage.GetItemData(pos);

				m_pPanelSettings->SendValue(mesg_no+m_nVoltageCfg, str);
			}
		}
	}
}
