using System;
using System.IO;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;

namespace CSLibTest
{
    class Program
    {
        [DllImport("NUCLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern Byte nucOpenDeviceHandler(int timer);
        [DllImport("NUCLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern void nucCloseDeviceHandler();
        [DllImport("NUCLib.dll", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.Cdecl)]
        public static extern void getNUCDevicePath(StringBuilder value);
        [DllImport("NUCLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern Byte isNUCConnected();
        [DllImport("NUCLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern float getNUCVIn();
        [DllImport("NUCLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern float getNUCIIn();
        [DllImport("NUCLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern float getNUCVOut();
        [DllImport("NUCLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern float getNUCIOut();
        [DllImport("NUCLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern float getNUCTemperature();
        [DllImport("NUCLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern float getNUCVIgnition();
        [DllImport("NUCLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern float getNUCPOut();
        [DllImport("NUCLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern float getNUCVThump();
        [DllImport("NUCLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern Byte getNUCVerMajor();
        [DllImport("NUCLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern Byte getNUCVerMinor();
        [DllImport("NUCLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern Byte getNUCState();

        [DllImport("NUCLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern Byte getNUCRemainingCapacity();

        [DllImport("NUCLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern Byte getNUCMode();
        
        [DllImport("NUCLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern void restartNUC();
        [DllImport("NUCLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern void restartNUCInBootloaderMode();

        //Flash stuff
        [DllImport("NUCLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern void startNUCLoadingSettings(Byte to_file, Byte compare_with_old);
        [DllImport("NUCLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern Byte getNUCLoadingSettingsState();
        [DllImport("NUCLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern int getNUCMaxVariableCnt();
        [DllImport("NUCLib.dll", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.Cdecl)]
        public static extern Byte getNUCVariableData(int cnt, StringBuilder name, StringBuilder value, StringBuilder unit, StringBuilder comment);
        [DllImport("NUCLib.dll", CharSet = CharSet.Ansi, CallingConvention = CallingConvention.Cdecl)]
        public static extern Byte setNUCVariableData(int cnt, String value);
        [DllImport("NUCLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern void startNUCSaveSettings(Byte from_file);
        [DllImport("NUCLib.dll", CallingConvention = CallingConvention.Cdecl)]
        public static extern Byte getNUCSaveSettingsState();

        static void Main(string[] args)
        {
            Console.WriteLine("HIT <Esc> TO EXIT!");

	        int state;

	        nucOpenDeviceHandler(1000);
	        if (isNUCConnected() == 1)
	        {
                Console.WriteLine("NUC opened!");
                System.Threading.Thread.Sleep(500);	//it's recommended to give a few miliseconds before the first read otherwise the first read might be 0 

		        //the library reads the NUC values in every 1000 msec (once per second)
		        //therefore is useless to read them faster from here

		        StringBuilder path = new StringBuilder(1024);
		        getNUCDevicePath(path);
        		
		        Console.Write(" firmware: ");Console.Write(getNUCVerMajor());Console.Write(".");Console.Write(getNUCVerMinor());Console.WriteLine();
		        Console.Write(" path: ");Console.Write(path);Console.WriteLine();
		        Console.WriteLine("------------------------------");
	        }
	        else Console.WriteLine("NUC not found!");

            ConsoleKey ch = ConsoleKey.Backspace;//no matter, just not Esc

            while (ch != ConsoleKey.Escape)
	        {
		        if (Console.KeyAvailable)
		        {
			        ch = Console.ReadKey().Key;
                    if (ch != ConsoleKey.Escape)
			        {
				        Console.WriteLine("Press again:\n");
				        Console.WriteLine("L.Load flash\nQ.Set flash 1\nW.Set flash 2\nA.Save settings to file\nS.Load settings from file");
                        char readch = Console.ReadKey().KeyChar;
                        switch (readch)
				        {
				        case 'l':
				        case 'L': 
					        {
						        Console.WriteLine("Loading flash values. Wait ...");
						        startNUCLoadingSettings(0,0);
						        int timeout = 0;
						        while ((getNUCLoadingSettingsState() < 100) && (timeout < 20))//wait for 10 seconds
						        {
							        Console.WriteLine("Loading ");Console.Write(getNUCLoadingSettingsState());Console.Write("%");
							        timeout++;
							        System.Threading.Thread.Sleep(500);
						        }
						        Console.WriteLine("Loading final: ");Console.Write(getNUCLoadingSettingsState());Console.Write("%");//100=OK, F0-FF=ERRORCODE
                                if (getNUCLoadingSettingsState() == 100)//succesfull
                                {
                                    int var_max = getNUCMaxVariableCnt();
                                    StringBuilder name = new StringBuilder(256);
                                    StringBuilder value = new StringBuilder(256);
                                    StringBuilder unit = new StringBuilder(256);
                                    StringBuilder comment = new StringBuilder(1024);

                                    for (int i = 0; i < var_max; i++)
                                        if (getNUCVariableData(i, name, value, unit, comment) != 0)
                                        {
                                            Console.Write("[");
                                            Console.Write(i);
                                            Console.Write("] ");
                                            Console.Write(name.ToString());
                                            Console.Write("=");
                                            Console.Write(value.ToString());
                                            Console.Write(" ");
                                            Console.Write(unit.ToString());
                                            Console.WriteLine();
                                        }
                                }
                                else
                                {
                                    Console.WriteLine("    ERROR: ");
                                    Console.Write(getNUCLoadingSettingsState());
                                }
					        }break;
				        case 'a':
				        case 'A':
					        {
						        Console.WriteLine("Saving flash values to file. Wait ...");
						        startNUCLoadingSettings(1,0);
						        int timeout = 0;
						        while ((getNUCLoadingSettingsState() < 100) && (timeout < 20))//wait for 10 seconds
						        {
							        Console.WriteLine("Loading ");Console.Write(getNUCLoadingSettingsState());Console.Write("%");
							        timeout++;
							        System.Threading.Thread.Sleep(500);
						        }
						        Console.WriteLine("Loading final: ");Console.Write(getNUCLoadingSettingsState());Console.Write("%");//100=OK, F0-FF=ERRORCODE
					        }break;
				        case 's':
				        case 'S':
					        {
						        Console.WriteLine("Loading flash values from file. Wait ...");
						        startNUCSaveSettings(1);
						        int timeout = 0;
						        while ((getNUCSaveSettingsState() < 100) && (timeout < 20))//wait for 10 seconds
						        {
                                    Console.WriteLine("Saving "); Console.Write(getNUCSaveSettingsState()); Console.Write("%");
							        timeout++;
							        System.Threading.Thread.Sleep(500);
						        }
						        Console.WriteLine("Saving final: ");Console.Write(getNUCSaveSettingsState());Console.Write("%");//100=OK, F0-FF=ERRORCODE
					        }break;
                        case 'q':
                        case 'Q':
                        case 'w':
                        case 'W':
                            {
                                if ((readch == 'q') || (readch == 'Q'))
                                {
                                    setNUCVariableData(23, "3111");//POUT_HIGH_THRESHOLD
                                    setNUCVariableData(22, "11111111");//CONFIG2
                                }
                                else
                                {
                                    setNUCVariableData(23, "3000");//POUT_HIGH_THRESHOLD
                                    setNUCVariableData(22, "00000000");//CONFIG2
                                }

                                startNUCSaveSettings(0);
                                int timeout = 0;
                                while ((getNUCSaveSettingsState() < 100) && (timeout < 20))//wait for 10 seconds
                                {
                                    Console.WriteLine("Saving ");Console.Write(getNUCSaveSettingsState());Console.Write("%");
                                    timeout++;
                                    System.Threading.Thread.Sleep(500);
                                }
                                Console.WriteLine("Saving final: ");Console.Write(getNUCSaveSettingsState());Console.Write("%");//100=OK, F0-FF=ERRORCODE
                            } break;
				        }
			        }
		        }
		        else
		        {
			        if (isNUCConnected() == 0)
			        {
				        //nucCloseDeviceHandler();//close it only if you do not want auto reconnect
				        Console.WriteLine("No device");
			        }
			        else
			        {
                        Console.Write("Mode="); Console.Write(getNUCMode());
                        Console.Write(" VIn="); Console.Write(getNUCVIn());
                        Console.Write(" IIn="); Console.Write(getNUCIIn());
                        Console.Write(" VOut="); Console.Write(getNUCVOut());
                        Console.Write(" IOut="); Console.Write(getNUCIOut());
                        if (getNUCTemperature() >= 1000) //not measured
                            Console.Write(" Tmp=--- ");
                        else { Console.Write(" Tmp="); Console.Write(getNUCTemperature()); }
                        Console.Write(" VIgn="); Console.Write(getNUCVIgnition());
                        Console.Write(" POut="); Console.Write(getNUCPOut());
                        Console.Write(" VTh="); Console.Write(getNUCVThump());
                        Console.WriteLine();
			        }
			        System.Threading.Thread.Sleep(1000);
		        }
	        }//while
            
	        nucCloseDeviceHandler();
        }
    }
}
