/* -*- pse-c -*-
 *-----------------------------------------------------------------------------
 * Filename: psb_intregs.h
 *-----------------------------------------------------------------------------
 * INTEL CONFIDENTIAL
 * Copyright (2002-2008) Intel Corporation All Rights Reserved.
 * The source code contained or described herein and all documents related to
 * the source code ("Material") are owned by Intel Corporation or its suppliers
 * or licensors. Title to the Material remains with Intel Corporation or its
 * suppliers and licensors. The Material contains trade secrets and proprietary
 * and confidential information of Intel or its suppliers and licensors. The
 * Material is protected by worldwide copyright and trade secret laws and
 * treaty provisions. No part of the Material may be used, copied, reproduced,
 * modified, published, uploaded, posted, transmitted, distributed, or
 * disclosed in any way without Intel's prior express written permission.
 * 
 * No license under any patent, copyright, trade secret or other intellectual
 * property right is granted to or conferred upon you by disclosure or
 * delivery of the Materials, either expressly, by implication, inducement,
 * estoppel or otherwise. Any license under such intellectual property rights
 * must be express and approved by Intel in writing.
 * 
 * 
 *-----------------------------------------------------------------------------
 * Description:
 *  This file contains nterrupt related routines for the PLB platform. 
 *-----------------------------------------------------------------------------
 */


#include "drmP.h"
#include "psb_intregs.h"
#include "iegd_drm.h"


irqreturn_t psb_irq_handler(DRM_IRQ_ARGS)
{
	int handled = 0;
	struct drm_device *dev = (struct drm_device *)arg;
	intel_device_private_t *priv=dev->dev_private;
	uint32_t vdc_stat, sgx_stat, sgx_stat2, mtx_stat;

	spin_lock(&priv->irqmask_lock);
	vdc_stat = PSB_RVDC32(IIR);
	sgx_stat = PSB_RSGX32(PSB_CR_EVENT_STATUS);
	sgx_stat2 = PSB_RSGX32(PSB_CR_EVENT_STATUS2);
	mtx_stat = PSB_RMSVDX32(PSB_MTX_EVENT_STATUS);
	vdc_stat &= priv->vdc_irq_mask;
	sgx_stat &= priv->sgx_irq_mask;
	sgx_stat2 &= priv->sgx_irq_mask2;
	mtx_stat &= priv->msvdx_irq_mask;

	if (vdc_stat) {
		PSB_WVDC32(vdc_stat, IIR);
		(void)PSB_RVDC32(IIR);

		priv->out_vdc |= vdc_stat;
		handled = 1;

		if (sgx_stat || sgx_stat2 || mtx_stat) {
			PSB_WSGX32(sgx_stat, PSB_CR_EVENT_HOST_CLEAR);
			(void)PSB_RSGX32(PSB_CR_EVENT_HOST_CLEAR);
			PSB_WSGX32(sgx_stat2, PSB_CR_EVENT_HOST_CLEAR2);
			(void)PSB_RSGX32(PSB_CR_EVENT_HOST_CLEAR2);
			PSB_WMSVDX32(mtx_stat, PSB_MTX_EVENT_CLEAR);
			(void)PSB_RMSVDX32(PSB_MTX_EVENT_CLEAR);

			priv->out_sgx |= sgx_stat;
			priv->out_sgx2 |= sgx_stat2;
			priv->out_mtx |= mtx_stat;

			priv->event_present = 1;
			spin_unlock(&priv->irqmask_lock);
			DRM_WAKEUP(&priv->event_queue);

		} else {

			spin_unlock(&priv->irqmask_lock);

		}

	} else {

			spin_unlock(&priv->irqmask_lock);

	}

	if (!handled) {
		return IRQ_NONE;
	}

	return IRQ_HANDLED;
}

void psb_irq_preinstall(struct drm_device *dev)
{
	intel_device_private_t *priv =
	(intel_device_private_t *)dev->dev_private;

	spin_lock(&priv->irqmask_lock);
	PSB_WVDC32(0xFFFFFFFF, HWSTAM);
	PSB_WVDC32(0xFFFFFFFF, IMR);
	PSB_WVDC32(0x00000000, IER);

	PSB_WSGX32(0x00000000, PSB_CR_EVENT_HOST_ENABLE);
	(void)PSB_RSGX32(PSB_CR_EVENT_HOST_ENABLE);
	PSB_WSGX32(0x00000000, PSB_CR_EVENT_HOST_ENABLE2);
	(void)PSB_RSGX32(PSB_CR_EVENT_HOST_ENABLE2);
	PSB_WMSVDX32(0x00000000, PSB_MTX_EVENT_HOST_ENABLE);
	(void)PSB_RMSVDX32(PSB_MTX_EVENT_HOST_ENABLE);

	priv->sgx_irq_mask = PSB_TWOD_COMPLETE |
		PSB_TA_FINISHED | PSB_TA_TERMINATE |
		PSB_PIXELBE_END_RENDER | PSB_DPM_3D_MEM_FREE |
		PSB_OUT_OF_MEM_MT | PSB_OUT_OF_MEM_GBL |
		PSB_REACHED_MEM_THRESH | PSB_DPM_TA_MEM_FREE |
		PSB_DPM_OUT_OF_MEM_ZLS | PSB_TA_DPM_FAULT;

	priv->sgx_irq_mask2 = PSB_BIF_REQ_FAULT | PSB_TRIG_TA | PSB_TRIG_3D |
		PSB_TRIG_DL;

	priv->vdc_irq_mask = IRQ_SGX_FLAG | IRQ_MSVDX_FLAG;

	priv->msvdx_irq_mask = (1<<14); /* Enable only MTX interrupt */

	spin_unlock(&priv->irqmask_lock);
}

void psb_irq_postinstall(struct drm_device *dev)
{
	intel_device_private_t *priv =
	(intel_device_private_t *)dev->dev_private;
	unsigned long irqflags;

	spin_lock_irqsave(&priv->irqmask_lock, irqflags);
	PSB_WVDC32(priv->vdc_irq_mask, IER);
	PSB_WSGX32(priv->sgx_irq_mask, PSB_CR_EVENT_HOST_ENABLE);
	(void)PSB_RSGX32(PSB_CR_EVENT_HOST_ENABLE);
	PSB_WSGX32(priv->sgx_irq_mask2, PSB_CR_EVENT_HOST_ENABLE2);
	(void)PSB_RSGX32(PSB_CR_EVENT_HOST_ENABLE2);
	PSB_WMSVDX32(priv->msvdx_irq_mask, PSB_MTX_EVENT_HOST_ENABLE);
	(void)PSB_RMSVDX32(PSB_MTX_EVENT_HOST_ENABLE);

	priv->irq_enabled = 1;
	spin_unlock_irqrestore(&priv->irqmask_lock, irqflags);
}

void psb_irq_uninstall(struct drm_device *dev)
{
	intel_device_private_t *priv =
	(intel_device_private_t *)dev->dev_private;
	unsigned long irqflags;

	spin_lock_irqsave(&priv->irqmask_lock, irqflags);

	priv->sgx_irq_mask = 0x00000000;
	priv->sgx_irq_mask2 = 0x00000000;
	priv->vdc_irq_mask = 0x00000000;
	priv->msvdx_irq_mask = 0x00000000;

	/* By default, we're enabling interrupts buy leaving them masked */
	PSB_WVDC32(0xFFFFFFFF, HWSTAM);
	PSB_WVDC32(0xFFFFFFFF, IMR);
	PSB_WVDC32(priv->vdc_irq_mask, IER);
	PSB_WSGX32(priv->sgx_irq_mask, PSB_CR_EVENT_HOST_ENABLE);
	PSB_WSGX32(priv->sgx_irq_mask2, PSB_CR_EVENT_HOST_ENABLE2);
	PSB_WMSVDX32(priv->msvdx_irq_mask, PSB_MTX_EVENT_HOST_ENABLE);
	wmb();
	PSB_WVDC32(PSB_RVDC32(IIR), IIR);
	PSB_WSGX32(PSB_RSGX32(PSB_CR_EVENT_STATUS), PSB_CR_EVENT_HOST_CLEAR);
	PSB_WSGX32(PSB_RSGX32(PSB_CR_EVENT_STATUS2), PSB_CR_EVENT_HOST_CLEAR2);
	PSB_WMSVDX32(PSB_RMSVDX32(PSB_MTX_EVENT_STATUS), PSB_MTX_EVENT_CLEAR);

	priv->irq_enabled = 0;
	spin_unlock_irqrestore(&priv->irqmask_lock, irqflags);
}
